package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 个性优惠券与折扣/item关系表dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "PersonalizeCouponRefReqDto",
        description = "个性优惠券与折扣/item关系dto"
)
public class PersonalizeCouponRefReqDto extends RequestDto {


    /**
     * 优惠券编码  券码的编码
     */
    @ApiModelProperty(name = "couponCode", value = "券码的编码")
    private String couponCode;

    /**
     * 优惠券id
     */
    @ApiModelProperty(name = "couponId", value = "couponId")
    private Long couponId;

    /**
     * 商品的折扣率
     */
    @ApiModelProperty(name = "discountValue", value = "商品的折扣率")
    private BigDecimal discountValue;
    /**
     * 最低消费金额
     */
    @ApiModelProperty(name = "leastPayAmt", value = "最低消费金额")
    private BigDecimal leastPayAmt;
    /**
     * 优惠券的个性面额
     */
    @ApiModelProperty(name = "couponAmt", value = "优惠券的个性面额")
    private BigDecimal couponAmt;

    @ApiModelProperty(name = "itemIds", value = "商品ids")
    private List<Long> itemIds;


    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public BigDecimal getDiscountValue() {
        return discountValue;
    }

    public void setDiscountValue(BigDecimal discountValue) {
        this.discountValue = discountValue;
    }

    public BigDecimal getLeastPayAmt() {
        return leastPayAmt;
    }

    public void setLeastPayAmt(BigDecimal leastPayAmt) {
        this.leastPayAmt = leastPayAmt;
    }

    public BigDecimal getCouponAmt() {
        return couponAmt;
    }

    public void setCouponAmt(BigDecimal couponAmt) {
        this.couponAmt = couponAmt;
    }

    public List<Long> getItemIds() {
        return itemIds;
    }

    public void setItemIds(List<Long> itemIds) {
        this.itemIds = itemIds;
    }
}
