/*
 * *
 *  * @(#)ActivityRespDto.java 2.0.0 18-12-13 下午2:48
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRuleItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel(value = "ActivityRespDto", description = "活动响应dto")
public class ActivityRespDto extends CommonVo {
    private static final long serialVersionUID = 34782273359565615L;

    private List<ConditionRespDto> conditionDtos;
    private List<ActionRespDto> actionDtos;
    private List<Long> policyIds;

    /**
     * 活动编号
     */
    @ApiModelProperty(name = "id")
    private Long id;

    /**
     * 活动名称
     */
    @ApiModelProperty(name = "activityName", value = "活动名称")
    private String activityName;
    /**
     * 活动logo
     */
    @ApiModelProperty(name = "activityLogo", value = "活动logo")
    private String activityLogo;
    /**
     * 活动销售数量
     */
    @ApiModelProperty(name = "activityLimit", value = "活动销售数量")
    private Long activityLimit;
    /**
     * 第三方Code
     */
    @ApiModelProperty(name = "thirdPartyCode", value = "第三方Code")
    private String thirdPartyCode;
    /**
     * 活动模板编号
     */
    @ApiModelProperty(name = "activityTemplateId", value = "活动模板编号")
    private Long activityTemplateId;

    /**
     * 内容模板编号
     */
    @ApiModelProperty(name = "contentId", value = "活动模板id")
    private Long contentTemplateId;

    /**
     * 内容编号
     */
    @ApiModelProperty(name = "contentId", value = "内容id")
    private Long contentId;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private Date beginTime;

    /**
     * 截止时间
     */
    @ApiModelProperty(name = "endTime", value = "截止时间")
    private Date endTime;

    /**
     * 定时执行表达式（quartz表达式）
     */
    private String execExpression;

    /**
     * 预告时间（不为空，则调用预告逻辑，由定制实现）
     */
    @ApiModelProperty(name = "noticeTime", value = "预告时间（不为空，则调用预告逻辑，由定制实现）")
    private Date noticeTime;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 活动状态（ENABLE：启用、DISABLE：停用、ACTIVITYING：活动中、TIMEOUT：暂停、FINISH：活动结束）
     */
    @ApiModelProperty(name = "activityStatus", value = "活动状态（ENABLE：启用、DISABLE：停用、ACTIVITYING：活动中、TIMEOUT：暂停、FINISH" +
            "：活动结束）")
    private String activityStatus;

    /**
     * 审核状态（NEW：新建、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：审核不通过）
     */
    @ApiModelProperty(name = "auditStatus", value = "审核状态（NEW：新建、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：审核不通过）")
    private String auditStatus;

    /**
     * 扩展字段，存放json
     */
    private String extension;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    /**
     * 商户id
     */
    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;

    /**
     * 活动预热开始时间
     */
    @ApiModelProperty(name = "preheatStartTime", value = "活动预热开始时间")
    private Date preheatStartTime;

    /**
     * 活动预热结束时间
     */
    @ApiModelProperty(name = "preheatEndTime", value = "活动预热结束时间")
    private Date preheatEndTime;

    /**
     * 活动范围：1-平台， 2-商家
     */
    @ApiModelProperty(name = "activityRange", value = "活动范围：1-平台， 2-商家")
    private Integer activityRange;

    /**
     * 活动编码
     */
    @ApiModelProperty(name = "activityCode", value = "活动编码")
    private String activityCode;

    /**
     * 活动模板
     */
    @ApiModelProperty(name = "activityTemplate", value = "活动模板")
    private ActivityTemplateRespDto activityTemplate;

    /**
     * 活动标签
     */
    @ApiModelProperty(name = "tag", value = "活动标签")
    private String tag;

    /**
     * 活动标签类型：0 默认 1 自定义
     */
    @ApiModelProperty(name = "tag", value = "活动标签类型：0 默认 1 自定义")
    private Integer tagType;

    /**
     * 促销方式（1：整单，2：单品）
     */
    @ApiModelProperty(name = "promotionMethod", value = "促销方式：1 整单，2 单品")
    private Integer promotionMethod;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id，必填")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "returnGoods", value = "赠品售后：true需退货，false不需要退货")
    private Boolean returnGoods;

    @ApiModelProperty(name = "userIds", value = "活动用户/客户")
    private List<Long> userIds;

    @ApiModelProperty(name = "selectType", value = "适用商品：0不限，1指定商品，2指定品类，")
    private Integer selectType;

    @ApiModelProperty(name = "selectCustomer", value = "适用客户：0不限，1指定类型，2指定客户")
    private Integer selectCustomer;

    @ApiModelProperty(name = "customerTypeIds", value = "客户类型")
    private String customerTypeIds;

    @ApiModelProperty(name = "customerAreaCodes", value = "客户区域")
    private String customerAreaCodes;

    @ApiModelProperty(name = "activityItemRespDtos", value = "活动商品信息")
    private List<ActivityItemRespDto> activityItemRespDtos;

    @ApiModelProperty(name = "activityRuleItemRespDtos", value = "组合套装商品信息")
    private List<ActivityRuleItemRespDto> activityRuleItemRespDtos;

    /**
     * 活动价格（单位：元）
     */
    @ApiModelProperty(name = "activityPrice", value = "活动价格")
    private BigDecimal activityPrice;

    @ApiModelProperty(name = "ifBalanceAccount", value = "是否额度累积：0 否 1 是")
    private Integer ifBalanceAccount;

    public Integer getIfBalanceAccount() {
        return ifBalanceAccount;
    }

    public void setIfBalanceAccount(Integer ifBalanceAccount) {
        this.ifBalanceAccount = ifBalanceAccount;
    }

    public List<ActivityItemRespDto> getActivityItemRespDtos() {
        return activityItemRespDtos;
    }

    public void setActivityItemRespDtos(List<ActivityItemRespDto> activityItemRespDtos) {
        this.activityItemRespDtos = activityItemRespDtos;
    }

    public List<ConditionRespDto> getConditionDtos() {
        return conditionDtos;
    }

    public void setConditionDtos(List<ConditionRespDto> conditionDtos) {
        this.conditionDtos = conditionDtos;
    }

    public List<ActionRespDto> getActionDtos() {
        return actionDtos;
    }

    public void setActionDtos(List<ActionRespDto> actionDtos) {
        this.actionDtos = actionDtos;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public Long getContentTemplateId() {
        return contentTemplateId;
    }

    public void setContentTemplateId(Long contentTemplateId) {
        this.contentTemplateId = contentTemplateId;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getExecExpression() {
        return execExpression;
    }

    public void setExecExpression(String execExpression) {
        this.execExpression = execExpression;
    }

    public Date getNoticeTime() {
        return noticeTime;
    }

    public void setNoticeTime(Date noticeTime) {
        this.noticeTime = noticeTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public List<Long> getPolicyIds() {
        return policyIds;
    }

    public void setPolicyIds(List<Long> policyIds) {
        this.policyIds = policyIds;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Date getPreheatStartTime() {
        return preheatStartTime;
    }

    public void setPreheatStartTime(Date preheatStartTime) {
        this.preheatStartTime = preheatStartTime;
    }

    public Date getPreheatEndTime() {
        return preheatEndTime;
    }

    public void setPreheatEndTime(Date preheatEndTime) {
        this.preheatEndTime = preheatEndTime;
    }

    public Integer getActivityRange() {
        return activityRange;
    }

    public void setActivityRange(Integer activityRange) {
        this.activityRange = activityRange;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public ActivityTemplateRespDto getActivityTemplate() {
        return activityTemplate;
    }

    public void setActivityTemplate(ActivityTemplateRespDto activityTemplate) {
        this.activityTemplate = activityTemplate;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getPromotionMethod() {
        return promotionMethod;
    }

    public void setPromotionMethod(Integer promotionMethod) {
        this.promotionMethod = promotionMethod;
    }

    public Boolean getReturnGoods() {
        return returnGoods;
    }

    public void setReturnGoods(Boolean returnGoods) {
        this.returnGoods = returnGoods;
    }

    public List<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public Integer getSelectCustomer() {
        return selectCustomer;
    }

    public void setSelectCustomer(Integer selectCustomer) {
        this.selectCustomer = selectCustomer;
    }

    public String getCustomerTypeIds() {
        return customerTypeIds;
    }

    public void setCustomerTypeIds(String customerTypeIds) {
        this.customerTypeIds = customerTypeIds;
    }

    public String getCustomerAreaCodes() {
        return customerAreaCodes;
    }

    public void setCustomerAreaCodes(String customerAreaCodes) {
        this.customerAreaCodes = customerAreaCodes;
    }

    public Integer getTagType() {
        return tagType;
    }

    public void setTagType(Integer tagType) {
        this.tagType = tagType;
    }

    public String getActivityLogo() {
        return activityLogo;
    }

    public void setActivityLogo(String activityLogo) {
        this.activityLogo = activityLogo;
    }

    public Long getActivityLimit() {
        return activityLimit;
    }

    public void setActivityLimit(Long activityLimit) {
        this.activityLimit = activityLimit;
    }

    public String getThirdPartyCode() {
        return thirdPartyCode;
    }

    public void setThirdPartyCode(String thirdPartyCode) {
        this.thirdPartyCode = thirdPartyCode;
    }

    public List<ActivityRuleItemRespDto> getActivityRuleItemRespDtos() {
        return activityRuleItemRespDtos;
    }

    public void setActivityRuleItemRespDtos(List<ActivityRuleItemRespDto> activityRuleItemRespDtos) {
        this.activityRuleItemRespDtos = activityRuleItemRespDtos;
    }

    public BigDecimal getActivityPrice() {
        return activityPrice;
    }

    public void setActivityPrice(BigDecimal activityPrice) {
        this.activityPrice = activityPrice;
    }
}
