/**
 * @(#) ActivityTemplateRespDto.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 活动模版响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ActivityTemplateRespDto", description = "活动模版响应Dto")
public class ActivityTemplateRespDto extends CommonVo {

    private static final long serialVersionUID = 3818428759385875954L;
    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
     * 模版编码
     */
    @ApiModelProperty(name = "templateCode", value = "模版编码")
    private String templateCode;
    /**
     * 模版名称
     */
    @ApiModelProperty(name = "templateName", value = "模版名称")
    private String templateName;
    /**
     * 内容模版编号
     */
    @ApiModelProperty(name = "contentTemplateId", value = "内容模版编号")
    private Long contentTemplateId;
//    /**
//     * 规则配置
//     */
//    @ApiModelProperty(name = "ruleConfig", value = "规则配置")
//    private String ruleConfig;

    /**
     * 活动类型（OLTP：离线处理<营销类>、OLAP：实时处理<促销类>）
     */
    @ApiModelProperty(name = "activityType", value = "活动类型（OLTP：离线处理-营销类、OLAP：实时处理-促销类）")
    private String activityType;
    /**
     * 模板状态（ENABLE：启用、DISABLE：停用）
     */
    @ApiModelProperty(name = "templateStatus", value = "模板状态（ENABLE：启用、DISABLE：停用）")
    private String templateStatus;
    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 权重
     */
    @ApiModelProperty(name = "weight", value = "权重")
    private Integer weight;

    /**
     * 活动维度
     */
    @ApiModelProperty(name = "dimension", value = "活动维度：1商品维度，2订单维度，3券维度")
    private Integer dimension;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Long getContentTemplateId() {
        return contentTemplateId;
    }

    public void setContentTemplateId(Long contentTemplateId) {
        this.contentTemplateId = contentTemplateId;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getTemplateStatus() {
        return templateStatus;
    }

    public void setTemplateStatus(String templateStatus) {
        this.templateStatus = templateStatus;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }
}
