package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.cube.biz.commons.annotation.ExcelColumnProperty;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 优惠券返回对象
 *
 * @author li.jundong
 * @date: 2019/6/21 16:29
 */
@ApiModel(
        value = "CouponExtRespDto",
        description = "优惠券返回结果dto"
)
public class CouponExtRespDto extends BaseRespDto {

    @ApiModelProperty(name = "id", value = "优惠券id")
    private Long id;

    @ApiModelProperty(name = "couponTemplateId", value = "券模板id")
    private Long couponTemplateId;

    @ApiModelProperty(name = "couponTemplateCode", value = "券模板编号")
    @ExcelColumnProperty(columnName = "券模板编号", index = 0)
    private String couponTemplateCode;

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "couponCode", value = "券码")
    @ExcelColumnProperty(columnName = "券码", index = 2)
    @Excel(name = "券码")
    private String couponCode;

    @ApiModelProperty(name = "batchNo", value = "批次号")
    @ExcelColumnProperty(columnName = "批次号", index = 1)
    private String batchNo;

    @ExcelColumnProperty(columnName = "核销人手机号", index = 4)
    @ApiModelProperty(name = "usePhone", value = "核销人手机号码")
    private String usePhone;

    @ExcelColumnProperty(columnName = "领取人手机号", index = 3)
    @ApiModelProperty(name = "receivePhone", value = "领取人手机号")
    private String receivePhone;

    @ApiModelProperty(name = "channel", value = "领取渠道")
    private String channel;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "receiveTime", value = "领取时间")
    private Date receiveTime;

    @ApiModelProperty(name = "effectiveTime", value = "生效时间")
    @ExcelColumnProperty(columnName = "生效时间", index = 5)
    private Date effectiveTime;

    @ApiModelProperty(name = "invalidTime", value = "失效时间")
    @ExcelColumnProperty(columnName = "失效时间", index = 6)
    private Date invalidTime;

    @ApiModelProperty(name = "useTime", value = "核销时间")
    private Date useTime;

    @ExcelColumnProperty(columnName = "核销时间", index = 7)
    @ApiModelProperty(name = "useTimeStr", value = "核销时间描述")
    private String useTimeStr;

    @ApiModelProperty(name = "couponStatus", value = "券状态,CouponStatusEnum枚举，10-已创建，40-已领取，20-已核销，30-已作废")
    private String couponStatus;

    @ExcelColumnProperty(columnName = "状态", index = 8)
    private String couponStatusDescription;

    @ApiModelProperty(name = "couponType", value = "优惠券类型")
    private String couponType;

    @ApiModelProperty(name = "useStoreName", value = "核销店铺名称")
    private String useStoreName;

    @ApiModelProperty(name = "couponValue", value = "优惠券面值")
    private BigDecimal couponValue;

    @ApiModelProperty(name = "amount", value = "优惠券使用阈值")
    private BigDecimal amount;

    @ApiModelProperty(name = "userId", value = "归属人id")
    private Long userId;

    @ApiModelProperty(name = "memberNo", value = "归属人会员编号")
    private String memberNo;

    @ApiModelProperty(name = "orderCode", value = "订单编号")
    private String orderCode;

    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(name = "activityCode", value = "营销活动代码，创建券活动的时候记录用，跟activity_id无关")
    private String activityCode;

    @ApiModelProperty(name = "hierarchy", value = "使用层级")
    private String hierarchy;

    @ApiModelProperty(name = "validityType", value = "有效期类型,1固定日期，2动态时期")
    private Integer validityType;

    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    @ApiModelProperty(name = "validityType", value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(name = "paymentCode", value = "支付编号")
    private String paymentCode;

    @ApiModelProperty(name = "outerOrderCode", value = "外部订单号，如淘宝订单号")
    private String outerOrderCode;

    @ApiModelProperty(name = "receiveStoreCode", value = "领取店铺编号")
    private String receiveStoreCode;

    @ApiModelProperty(name = "useStoreCode", value = "核销店铺编号")
    private String useStoreCode;

    @ApiModelProperty(name = "useMemberId", value = "核销会员id")
    private Long useMemberId;

    @ApiModelProperty(name = "useChannel", value = "核销渠道")
    private String useChannel;

    @ApiModelProperty(name = "useAmount", value = "核销金额")
    private BigDecimal useAmount;

    @ApiModelProperty(name = "useMemberNo", value = "核销会员编号")
    private String useMemberNo;

    @ApiModelProperty(name = "shopType", value = "适用店铺, 10=所有店铺, 20=线上店铺, 30=线下店铺, 40=自定义店铺")
    private Integer shopType;

    @ApiModelProperty(name = "couponTemplate", value = "优惠券模板信息")
    private CouponTemplateExtRespDto couponTemplate;

    /**
     * 券范围类型：10=平台券，20=店铺券
     */
    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    private Integer couponRange;

    /**
     * 下单时映射券对应的可用商品
     */
    @ApiModelProperty(name = "availableItems", value = "可用商品集合")
    private List<ItemVo> availableItems;

    /**
     * 券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券
     */
    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券")
    private Integer couponCategory;

    @ApiModelProperty(name = "券模板关联的活动标签", value = "活动标签")
    private String activityTag;

    /**
     *  店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     *  店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getCouponTemplateCode() {
        return couponTemplateCode;
    }

    public void setCouponTemplateCode(String couponTemplateCode) {
        this.couponTemplateCode = couponTemplateCode;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getUsePhone() {
        return usePhone;
    }

    public void setUsePhone(String usePhone) {
        this.usePhone = usePhone;
    }

    public String getReceivePhone() {
        return receivePhone;
    }

    public void setReceivePhone(String receivePhone) {
        this.receivePhone = receivePhone;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    public String getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(String couponStatus) {
        this.couponStatus = couponStatus;
    }

    public String getCouponStatusDescription() {
        return couponStatusDescription;
    }

    public void setCouponStatusDescription(String couponStatusDescription) {
        this.couponStatusDescription = couponStatusDescription;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getPaymentCode() {
        return paymentCode;
    }

    public void setPaymentCode(String paymentCode) {
        this.paymentCode = paymentCode;
    }

    public String getOuterOrderCode() {
        return outerOrderCode;
    }

    public void setOuterOrderCode(String outerOrderCode) {
        this.outerOrderCode = outerOrderCode;
    }

    public String getReceiveStoreCode() {
        return receiveStoreCode;
    }

    public void setReceiveStoreCode(String receiveStoreCode) {
        this.receiveStoreCode = receiveStoreCode;
    }

    public String getUseStoreCode() {
        return useStoreCode;
    }

    public void setUseStoreCode(String useStoreCode) {
        this.useStoreCode = useStoreCode;
    }

    public Long getUseMemberId() {
        return useMemberId;
    }

    public void setUseMemberId(Long useMemberId) {
        this.useMemberId = useMemberId;
    }

    public String getUseChannel() {
        return useChannel;
    }

    public void setUseChannel(String useChannel) {
        this.useChannel = useChannel;
    }

    public BigDecimal getUseAmount() {
        return useAmount;
    }

    public void setUseAmount(BigDecimal useAmount) {
        this.useAmount = useAmount;
    }

    public String getUseMemberNo() {
        return useMemberNo;
    }

    public void setUseMemberNo(String useMemberNo) {
        this.useMemberNo = useMemberNo;
    }

    public Integer getShopType() {
        return shopType;
    }

    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }

    public CouponTemplateExtRespDto getCouponTemplate() {
        return couponTemplate;
    }

    public void setCouponTemplate(CouponTemplateExtRespDto couponTemplate) {
        this.couponTemplate = couponTemplate;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getUseTimeStr() {
        return useTimeStr;
    }

    public void setUseTimeStr(String useTimeStr) {
        this.useTimeStr = useTimeStr;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public List<ItemVo> getAvailableItems() {
        return availableItems;
    }

    public void setAvailableItems(List<ItemVo> availableItems) {
        this.availableItems = availableItems;
    }

    /**
     * 判断优惠券是否开始
     *
     * @param
     * @return boolean
     * @author li.jundong
     * @date 2019/7/22
     */
    public int isStart() {
        boolean isStart = false;
        if (couponTemplate != null) {
            if (couponTemplate.getValidityType().equals(CouponValidityTypeEnum.DYNAMIC_DATE.getType())) {
                if (this.effectiveTime == null) {
                    isStart = true;
                } else {
                    isStart = this.effectiveTime.before(new Date()) && this.invalidTime.after(new Date());
                }
            } else {
                if (couponTemplate.getEffectiveTime() == null) {
                    isStart = true;
                } else {
                    isStart = couponTemplate.getEffectiveTime().before(new Date()) && couponTemplate.getInvalidTime().after(new Date());
                }
            }
        }
        return isStart ? 1 : 0;
    }

    /**
     * 判断优惠券是否结束
     *
     * @param
     * @return boolean
     * @author li.jundong
     * @date 2019/7/22
     */
    public int isEnd() {
        boolean isEnd = false;
        if (couponTemplate != null) {
            if (couponTemplate.getValidityType().equals(CouponValidityTypeEnum.DYNAMIC_DATE.getType())) {
                if (this.invalidTime != null) {
                    isEnd = this.invalidTime.before(new Date());
                }
            } else {
                if (couponTemplate.getInvalidTime() != null) {
                    isEnd = couponTemplate.getInvalidTime().before(new Date());
                }
            }
        }
        return isEnd ? 1 : 0;
    }

    public String getUseStoreName() {
        return useStoreName;
    }

    public void setUseStoreName(String useStoreName) {
        this.useStoreName = useStoreName;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }
}
