/**
 * @(#)CouponItemRangeRespDto.java 1.0 2019年1月10日
 *
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 优惠券商品使用范围响应dto
 * 
 * @author 水镜
 * @since 2.0.0
 */
@ApiModel(value = "CouponItemRangeRespDto", description = "优惠券商品范围dto")
public class CouponItemRangeRespDto extends RequestDto {

	private static final long serialVersionUID = 1L;

	/**
	 * 优惠券模板编号
	 */
	@ApiModelProperty(name = "id", value = "优惠券模板编号")
	private Long id;

	/**
	 * 商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）
	 */
	@ApiModelProperty(name = "itemRange", value = "商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）")
	private String itemRange;

	/**
	 * 商户ID集合
	 */
	@ApiModelProperty(name = "sellerIdList", value = "商户ID集合")
	private List<Long> sellerIdList;

	/**
	 * 店铺ID集合
	 */
	@ApiModelProperty(name = "shopIdList", value = "店铺ID集合")
	private List<Long> shopIdList;

	/**
	 * 类目id集合
	 */
	@ApiModelProperty(name = "categoryIdList", value = "类目id集合")
	private List<Long> categoryIdList;

	/**
	 * 商品id集合
	 */
	@ApiModelProperty(name = "itemIdList", value = "商品id集合")
	private List<Long> itemIdList;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getItemRange() {
		return itemRange;
	}

	public void setItemRange(String itemRange) {
		this.itemRange = itemRange;
	}

	public List<Long> getSellerIdList() {
		return sellerIdList;
	}

	public void setSellerIdList(List<Long> sellerIdList) {
		this.sellerIdList = sellerIdList;
	}

	public List<Long> getShopIdList() {
		return shopIdList;
	}

	public void setShopIdList(List<Long> shopIdList) {
		this.shopIdList = shopIdList;
	}

	public List<Long> getCategoryIdList() {
		return categoryIdList;
	}

	public void setCategoryIdList(List<Long> categoryIdList) {
		this.categoryIdList = categoryIdList;
	}

	public List<Long> getItemIdList() {
		return itemIdList;
	}

	public void setItemIdList(List<Long> itemIdList) {
		this.itemIdList = itemIdList;
	}

}
