package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @Description: 优惠券满减（满折）条件参数
 * @Author: 可乐
 * @Date: 2019/11/19 16:05
 * @Version: 0.1.0
 */
@ApiModel(value = "CouponMoneyOffDto", description = "优惠券满减（满折）条件参数")
public class CouponMoneyOffDto extends BaseVo {

    /**
     * 达到多少金额才满足
     */
    @ApiModelProperty(name = "limitAmount", value = "达到多少金额才满足")
    private BigDecimal limitAmount;

    /**
     * 条件
     */
    @ApiModelProperty(name = "condition", value = "条件")
    private Integer condition;

    /**
     * 条件单位。1元，2件
     */
    @ApiModelProperty(name = "priceType", value = "条件单位。1元，2件")
    private Integer priceType;

    /**
     * 折扣率或者现金
     */
    @ApiModelProperty(name = "discountValue", value = "折扣率或者现金")
    private BigDecimal discountValue;

    /**
     * 最大抵扣金额限制
     */
    @ApiModelProperty(name = "maxDiscountValue", value = "最大抵扣金额限制")
    private BigDecimal maxDiscountValue;

    public CouponMoneyOffDto() {
    }

    public BigDecimal getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(BigDecimal limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Integer getCondition() {
        return condition;
    }

    public void setCondition(Integer condition) {
        this.condition = condition;
    }

    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }

    public BigDecimal getDiscountValue() {
        return discountValue;
    }

    public void setDiscountValue(BigDecimal discountValue) {
        this.discountValue = discountValue;
    }

    public BigDecimal getMaxDiscountValue() {
        return maxDiscountValue;
    }

    public void setMaxDiscountValue(BigDecimal maxDiscountValue) {
        this.maxDiscountValue = maxDiscountValue;
    }
}
