package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 券包信息返回dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponPackRespDto",
        description = "券包信息返回dto"
)
public class CouponPackRespDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    @ApiModelProperty(name = "couponPackName", value = "券包名称")
    private String couponPackName;

    @ApiModelProperty(name = "couponPackUrl", value = "券包url")
    private String couponPackUrl;
    @ApiModelProperty(name = "couponPackCode", value = "券包编码")
    private String couponPackCode;
    /**
     * 券包说明
     */
    @ApiModelProperty(name = "remark", value = "券包说明")
    private String remark;

    /**
     * 券包类型 1=营销类, 2=权益类, 3=付费类
     */
    @ApiModelProperty(name = "couponPackType", value = "券包类型 1=营销类, 2=权益类, 3=付费类")
    private Integer couponPackType;

    @ApiModelProperty(name = "pushType", value = "优惠券包的发放类型(默认0:部分发放)")
    private Integer pushType;

    @ApiModelProperty(name = "relationType", value = "关联方式(0:手动,1:个性化)")
    private Integer relationType;
    /**
     * 券包状态 1=已启用, 0=已停用
     */
    @ApiModelProperty(name = "couponPackStatus", value = "券包状态 1=已激活, 0=已停用")
    private Integer couponPackStatus;
    /**
     * 券包包含优惠券数量
     */
    @ApiModelProperty(name = "totalIssueQuantity", value = "券包包含优惠券数量")
    private Integer totalIssueQuantity;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "couponPackTemplateReqDtos", value = "优惠券模板信息集合")
    private List<CouponPackTemplateRespDto> couponPackTemplateRespDtocs;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCouponPackStatus() {
        return couponPackStatus;
    }

    public void setCouponPackStatus(Integer couponPackStatus) {
        this.couponPackStatus = couponPackStatus;
    }

    public Integer getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Integer totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCouponPackName() {
        return couponPackName;
    }

    public void setCouponPackName(String couponPackName) {
        this.couponPackName = couponPackName;
    }

    public String getCouponPackUrl() {
        return couponPackUrl;
    }

    public void setCouponPackUrl(String couponPackUrl) {
        this.couponPackUrl = couponPackUrl;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getCouponPackType() {
        return couponPackType;
    }

    public void setCouponPackType(Integer couponPackType) {
        this.couponPackType = couponPackType;
    }

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public List<CouponPackTemplateRespDto> getCouponPackTemplateReqDtos() {
        return couponPackTemplateRespDtocs;
    }

    public void setCouponPackTemplateReqDtos(List<CouponPackTemplateRespDto> couponPackTemplateRespDtocs) {
        this.couponPackTemplateRespDtocs = couponPackTemplateRespDtocs;
    }

    public String getCouponPackCode() {
        return couponPackCode;
    }

    public void setCouponPackCode(String couponPackCode) {
        this.couponPackCode = couponPackCode;
    }

    public List<CouponPackTemplateRespDto> getCouponPackTemplateRespDtocs() {
        return couponPackTemplateRespDtocs;
    }

    public void setCouponPackTemplateRespDtocs(List<CouponPackTemplateRespDto> couponPackTemplateRespDtocs) {
        this.couponPackTemplateRespDtocs = couponPackTemplateRespDtocs;
    }
}
