package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;


import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 券包内的模板请求dto
 *
 * @author 晓至
 */
@ApiModel(
        value = "CouponPackTemplateRespDto",
        description = "券包内的模板返回dto"
)
public class CouponPackTemplateRespDto extends BaseVo {

    /**
     * 优惠券模板id
     */
    @ApiModelProperty(name = "id", value = "优惠券模板id")
    private Long id;

    /**
     * 优惠券模板编号
     */
    @ApiModelProperty(name = "couponCode", value = "优惠券模板编号")
    private String couponCode;

    /**
     * 优惠券模板名称
     */
    @ApiModelProperty(name = "couponName", value = "优惠券模板名称")
    private String couponName;

    /**
     * 面值（单位：元或百分比）
     */
    @ApiModelProperty(name = "couponValue", value = "面值（单位：元或百分比）")
    private BigDecimal couponValue;

    /**
     * 优惠券模板状态
     */
    @ApiModelProperty(name = "couponTemplateStatus", value = "优惠券模板状态, 10=已创建, 20=已激活, 30=已停用, 40=已作废")
    private String couponTemplateStatus;

    /**
     * 优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券, 06=运费券  CouponTypeEnum类
     */
    @ApiModelProperty(name = "couponType", value = "优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券, 06=运费券 10优惠券（手动发放 11个性化")
    private String couponType;
    /**
     * 发放总数量（单位：张）
     */
    @ApiModelProperty(name = "totalIssueQuantity", value = "预计发放量")
    private Long totalIssueQuantity;

    /**
     * 剩余库存数量   已发放数量需要== 总的-剩余
     */
    @ApiModelProperty(name = "remainingQuantity", value = "剩余库存数量(已发放数量需要== 总的-剩余)")
    private Long remainingQuantity;

    /**
     * 生效时间
     */
    @ApiModelProperty(name = "effectiveTime", value = "生效时间")
    private Date effectiveTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Long getRemainingQuantity() {
        return remainingQuantity;
    }

    public void setRemainingQuantity(Long remainingQuantity) {
        this.remainingQuantity = remainingQuantity;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }
}
