package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 优惠券发放(系统推券)返回发券失败信息
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponPushErrorDto",
        description = "优惠券发放(系统推券)返回信息dto"
)
public class CouponPushErrorDto implements Serializable {

    @ApiModelProperty(name = "couponTemplateId", value = "优惠券模板Id")
    private Long couponTemplateId;

    @ApiModelProperty(name = "memberId", value = "发放失败的用户")
    private Long memberId;

    @ApiModelProperty(name = "errorCode", value = "错误码")
    private String errorCode;

    @ApiModelProperty(name = "errorMsg", value = "错误信息")
    private String errorMsg;

    public CouponPushErrorDto(Long couponTemplateId, Long memberId, String errorCode, String errorMsg) {
        this.couponTemplateId = couponTemplateId;
        this.memberId = memberId;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public CouponPushErrorDto() {
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
