package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 优惠券发放(系统推券)返回信息，
 * 例如：{"failData":[{"couponTemplateId":1212983588195700813,"errorCode":"1312","errorMsg":"领取限制未配置","memberId":1212980625929744416},{"errorCode":"1310","errorMsg":"优惠券模板为非激活状态","memberId":1213005265422069870}],"failNum":2,"successNum":3}
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponPushRespDto",
        description = "优惠券发放(系统推券)返回信息dto"
)
public class CouponPushRespDto implements Serializable {


    private static final long serialVersionUID = 4334258577667002011L;
    @ApiModelProperty(name = "successNum", value = "发放成功数量")
    private Integer successNum;

    @ApiModelProperty(name = "failNum", value = "发放失败数量")
    private Integer failNum;

    @ApiModelProperty(name = "successData", value = "推送成功数据")
    private List<CouponPushSuccessDto> successData;

    @ApiModelProperty(name = "failData", value = "推送失败数据")
    private List<CouponPushErrorDto> failData;

    public CouponPushRespDto(Integer successNum, Integer failNum, List<CouponPushErrorDto> failData) {
        this.successNum = successNum;
        this.failNum = failNum;
        this.failData = failData;
    }

    public CouponPushRespDto(Integer successNum, Integer failNum, List<CouponPushSuccessDto> successData, List<CouponPushErrorDto> failData) {
        this.successNum = successNum;
        this.failNum = failNum;
        this.successData = successData;
        this.failData = failData;
    }

    public CouponPushRespDto() {
    }

    public Integer getSuccessNum() {
        return successNum;
    }

    public void setSuccessNum(Integer successNum) {
        this.successNum = successNum;
    }

    public Integer getFailNum() {
        return failNum;
    }

    public void setFailNum(Integer failNum) {
        this.failNum = failNum;
    }

    public List<CouponPushErrorDto> getFailData() {
        return failData;
    }

    public void setFailData(List<CouponPushErrorDto> failData) {
        this.failData = failData;
    }

    public List<CouponPushSuccessDto> getSuccessData() {
        return successData;
    }

    public void setSuccessData(List<CouponPushSuccessDto> successData) {
        this.successData = successData;
    }

    public static void main(String[] args) {
        CouponPushRespDto couponPushRespDto = new CouponPushRespDto();
        couponPushRespDto.setSuccessNum(3);
        couponPushRespDto.setFailNum(2);

        List<CouponPushErrorDto> list = new ArrayList<>();
        CouponPushErrorDto e1 = new CouponPushErrorDto();
        e1.setMemberId(1212980625929744416L);
        e1.setCouponTemplateId(1212983588195700813L);
        e1.setErrorCode("1312");
        e1.setErrorMsg("领取限制未配置");

        CouponPushErrorDto e2 = new CouponPushErrorDto();
        e2.setMemberId(1213005265422069870L);
        e1.setCouponTemplateId(1212983588195700813L);
        e2.setErrorCode("1310");
        e2.setErrorMsg("优惠券模板为非激活状态");

        list.add(e1);
        list.add(e2);
        couponPushRespDto.setFailData(list);

        System.out.println(JSON.toJSONString(couponPushRespDto));

    }
}
