package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.Channel;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponStatus;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.ItemRange;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.UseSuperimposedType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠券
 *
 * @author tuyun
 * @since 2.0.0
 */
public class CouponResDto extends CommonVo {

    private static final long serialVersionUID = -885731669374157951L;
    private Long id;

    /**
     * 券类型（现金券：CASH、折扣券：DISCOUNT）
     */
    private CouponType couponType;

    /**
     * 使用渠道（ONLINE：线上渠道、OFFLINE：线下渠道）
     */
    private Channel channel;

    /**
     * 叠加使用类型（NO：不允许叠加使用、YES_DIF：不同券定义允许叠加使用、YES_DIF_SAME：不同券定义&相同券定义不同的券都允许叠加）
     */
    private UseSuperimposedType useSuperimposedType;

    /**
     * 优惠券编码
     */
    private String couponCode;

    /**
     * 面值（单位：元或百分比）
     */
    private BigDecimal couponValue;

    /**
     * 生效时间
     */
    private Date effectiveTime;

    /**
     * 失效时间
     */
    private Date invalidTime;

    /**
     * 状态（NOT_CONSUMED：未消费、HAS_CONSUMED：已消费、FREEZE：冻结）
     */
    private CouponStatus couponStatus;

    /**
     * 活动编号
     */
    private Long activityId;

    /**
     * 券模板编号
     */
    private Long couponTemplateId;

    /**
     * 商品使用范围（使用范围：ALL：全部商品、PART）
     */
    private ItemRange itemRange;

    /**
     * 金额阈值，当达到该阈值，才能使用券
     */
    private BigDecimal amount;

    /**
     * 归属人
     */
    private Long userId;

    private Date useTime;

    private String orderCode;

    /**
     * 扩展字段，存放json
     */
    private String extension;

    private String couponName;


    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CouponType getCouponType() {
        return couponType;
    }

    public void setCouponType(CouponType couponType) {
        this.couponType = couponType;
    }

    public Channel getChannel() {
        return channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public UseSuperimposedType getUseSuperimposedType() {
        return useSuperimposedType;
    }

    public void setUseSuperimposedType(UseSuperimposedType useSuperimposedType) {
        this.useSuperimposedType = useSuperimposedType;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public CouponStatus getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(CouponStatus couponStatus) {
        this.couponStatus = couponStatus;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public ItemRange getItemRange() {
        return itemRange;
    }

    public void setItemRange(ItemRange itemRange) {
        this.itemRange = itemRange;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
