package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 券信息
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "CouponRespDto", description = "券信息")
public class CouponRespDto extends CommonVo {

    private static final long serialVersionUID = 2020243496199916347L;
    /**
     * 券编号
     */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    private String couponType;

    /**
     * 使用渠道（ONLINE：线上渠道、OFFLINE：线下渠道）
     */
    @ApiModelProperty(name = "channel", value = "使用渠道（ONLINE：线上渠道、OFFLINE：线下渠道")
    private String channel;

    /**
     * 叠加使用类型（NO：不允许叠加使用、YES_DIF：不同券定义允许叠加使用、YES_DIF_SAME：不同券定义&相同券定义不同的券都允许叠加）
     */
    @ApiModelProperty(name = "use_superimposed_type",
            value = "叠加使用类型（NO：不允许叠加使用、YES_DIF：不同券定义允许叠加使用、YES_DIF_SAME：不同券定义&相同券定义不同的券都允许叠加）")
    private String useSuperimposedType;

    /**
     * 优惠券编码
     */
    @ApiModelProperty(name = "coupon_code", value = "优惠券编码")
    private String couponCode;

    /**
     * 面值（单位：元或百分比）
     */
    @ApiModelProperty(name = "coupon_value", value = "面值（单位：元或百分比）")
    private BigDecimal couponValue;

    /**
     * 生效时间
     */
    @ApiModelProperty(name = "effective_time", value = "生效时间")
    private Date effectiveTime;

    /**
     * 失效时间
     */
    @ApiModelProperty(name = "invalid_time", value = "失效时间")
    private Date invalidTime;

    /**
     * 状态（NOT_CONSUMED：未消费、HAS_CONSUMED：已消费、FREEZE：冻结）
     */
    @ApiModelProperty(name = "coupon_status", value = "状态（NOT_CONSUMED：未消费、HAS_CONSUMED：已消费、FREEZE：冻结）")
    private String couponStatus;

    /**
     * 活动编号
     */
    @ApiModelProperty(name = "activity_id", value = "活动编号")
    private Long activityId;

    /**
     * 券模板编号
     */
    @ApiModelProperty(name = "coupon_template_id", value = "券模板编号")
    private Long couponTemplateId;

    /**
     * 商品使用范围（使用范围：ALL：全部商品、PART）
     */
    @ApiModelProperty(name = "item_range", value = "商品使用范围（使用范围：ALL：全部商品、PART）")
    private String itemRange;

    /**
     * 金额阈值，当达到该阈值，才能使用券
     */
    @ApiModelProperty(name = "amount", value = "金额阈值，当达到该阈值，才能使用券")
    private BigDecimal amount;

    /**
     * 归属人
     */
    @ApiModelProperty(name = "user_id", value = "归属人")
    private Long userId;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;

    private Date useTime;

    private String orderCode;
    private String couponName;


    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getUseSuperimposedType() {
        return useSuperimposedType;
    }

    public void setUseSuperimposedType(String useSuperimposedType) {
        this.useSuperimposedType = useSuperimposedType;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public String getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(String couponStatus) {
        this.couponStatus = couponStatus;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
