package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 优惠券发放返回信息
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponSendRespDto",
        description = "优惠券发放返回结果dto"
)
public class CouponSendRespDto implements Serializable {

    @ApiModelProperty(name = "couponId", value = "优惠券ID")
    private Long couponId;

    @ApiModelProperty(name = "couponCode", value = "优惠券编码")
    private String couponCode;

    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(name = "successNum", value = "发放成功数量")
    private Integer successNum;

    @ApiModelProperty(name = "failNum", value = "发放失败数量")
    private Integer failNum;

    public CouponSendRespDto() {
    }

    public CouponSendRespDto(Integer successNum, Integer failNum) {
        this.successNum = successNum;
        this.failNum = failNum;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Integer getSuccessNum() {
        return successNum;
    }

    public void setSuccessNum(Integer successNum) {
        this.successNum = successNum;
    }

    public Integer getFailNum() {
        return failNum;
    }

    public void setFailNum(Integer failNum) {
        this.failNum = failNum;
    }
}
