package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 营销发放给会员的待领取优惠券模板
 * @author : 萧玄
 * @Date   : 9:09 2019/7/16
 */
@ApiModel(
        value = "CouponTemplate4MemberRespDto",
        description = "营销发放给会员的待领取优惠券模板"
)
public class CouponTemplate4MemberRespDto extends RequestDto {

    /**
     * 优惠券模板列表
     */
    @ApiModelProperty(name = "ids", value = "优惠券模板列表")
    private List<CouponBaseDto> coupoTemplates;

    /**
     * 优惠券推送方式(1：领券中心-通用 2：领券中心-精准)
     */
    @ApiModelProperty(name = "couponPushMethod", value = "优惠券推送方式(1：领券中心-通用 2：领券中心-精准)")
    private Integer couponPushMethod;


    public List<CouponBaseDto> getCouponTemplates() {
        return coupoTemplates;
    }

    public void setCouponTemplates(List<CouponBaseDto> coupoTemplates) {
        this.coupoTemplates = coupoTemplates;
    }

    public Integer getCouponPushMethod() {
        return couponPushMethod;
    }

    public void setCouponPushMethod(Integer couponPushMethod) {
        this.couponPushMethod = couponPushMethod;
    }

}
