package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @Description: 优惠券模板品牌参数
 * @Author: 可乐
 * @Date: 2019/11/18 15:34
 * @Version: 0.1.0
 */
@ApiModel(value = "CouponTemplateBrandDto", description = "优惠券模板品牌参数")
public class CouponTemplateBrandDto implements Serializable {

    @ApiModelProperty(name = "brandId", value = "商品品牌ID")
    private Long brandId;

    @ApiModelProperty(name = "exclude", value = "不包含")
    private boolean exclude;

    public CouponTemplateBrandDto() {
    }

    public CouponTemplateBrandDto(Long brandId) {
        this.brandId = brandId;
    }

    public CouponTemplateBrandDto(Long brandId, boolean exclude) {
        this.brandId = brandId;
        this.exclude = exclude;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public boolean isExclude() {
        return exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }
}
