package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 优惠券模板返回结果dto
 * @author li.jundong
 * @date: 2019/6/21 15:11
 */
@ApiModel(
        value = "CouponTempateExtRespDto",
        description = "优惠券模板返回结果dto"
)
public class CouponTemplateExtRespDto extends BaseRespDto {

    /**
     * 优惠券模板id
     */
    @ApiModelProperty(name = "id", value = "优惠券模板id")
    private Long id;

    /**
     * 营销活动代码
     */
    @ApiModelProperty(name = "marketingCode", value = "营销活动代码")
    private String marketingCode;

    /**
     * 优惠券模板编号
     */
    @ApiModelProperty(name = "couponCode", value = "优惠券模板编号")
    private String couponCode;

    /**
     * 优惠券模板名称
     */
    @ApiModelProperty(name = "couponName", value = "优惠券模板名称")
    private String couponName;

    /**
     * 活动id
     */
    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    /**
     * 优惠券模板状态
     */
    @ApiModelProperty(name = "couponTemplateStatus", value = "优惠券模板状态, 10=已创建, 20=已激活, 30=已停用, 40=已作废")
    private String couponTemplateStatus;

    /**
     * 券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券
     */
    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券")
    private Integer couponCategory;

    /**
     * 优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券, 06=运费券
     */
    @ApiModelProperty(name = "couponType", value = "优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券 06提货券 11个性化优惠券 12服务券")
    private String couponType;

    /**
     * 发放总数量（单位：张）
     */
    @ApiModelProperty(name = "totalIssueQuantity", value = "发放总数量（单位：张）")
    private Long totalIssueQuantity;

    /**
     * 剩余库存数量
     */
    @ApiModelProperty(name = "remainingQuantity", value = "剩余库存数量")
    private Long remainingQuantity;

    /**
     * 领取开始时间
     */
    @ApiModelProperty(name = "receiveStartTime", value = "领取开始时间")
    private Date receiveStartTime;

    /**
     * 领取截止时间
     */
    @ApiModelProperty(name = "receiveEndTime", value = "领取截止时间")
    private Date receiveEndTime;

    /**
     * 生效时间
     */
    @ApiModelProperty(name = "effectiveTime", value = "生效时间")
    private Date effectiveTime;

    /**
     * 失效时间
     */
    @ApiModelProperty(name = "invalidTime", value = "失效时间")
    private Date invalidTime;

    /**
     * 面值（单位：元或百分比）
     */
    @ApiModelProperty(name = "couponValue", value = "面值（单位：元或百分比）")
    private BigDecimal couponValue;

    /**
     * 金额阈值，当达到该阈值，才能使用券
     */
    @ApiModelProperty(name = "couponName", value = "金额阈值，当达到该阈值，才能使用券")
    private BigDecimal amount;

    @ApiModelProperty(
            name = "isDirectional",
            value = "是否定向券, 1是0否"
    )
    private Integer isDirectional;

    @ApiModelProperty(
            name = "mutexType",
            value = "10=不限制互斥, 20=与所有券互斥, 30=与订单级电子券互斥, 40=与商品级电子券互斥, 50=与平台券互斥，60=与店铺券互斥"
    )
    private Integer mutexType;

    @ApiModelProperty(
            name = "shopType",
            value = "10=所有店铺, 20=线上店铺, 30=线下店铺, 40=自定义店铺"
    )
    private Integer shopType;

    /**
     * 10=售后安抚, 20=会员活动, 21=会员维护, 22=会员福利, 30=客商团购, 40=主题促销H5游戏,
     * 41=新店开业/老店店庆, 42=异业合作, 43=地推活动, 44=商品活动, 50=其它
     */
    @ApiModelProperty(name = "purpose", value = "10=售后安抚, 20=会员活动, 21=会员维护, 22=会员福利, 30=客商团购, 40=主题促销H5游戏," +
                                                "41=新店开业/老店店庆, 42=异业合作, 43=地推活动, 44=商品活动, 50=其它")
    private Integer purpose;

    /**
     * 使用层级, 10=订单电子券, 20=品类电子券, 30=商品电子券，40=店铺电子券，50=通用层级
     */
    @ApiModelProperty(name = "hierarchy", value = "10=订单电子券, 20=品类电子券, 30=商品电子券, 40=店铺电子券，50=通用层级")
    private String hierarchy;
    /**
     * 券供应商
     */
    @ApiModelProperty(name = "supplier", value = "券供应商")
    private String supplier;

    /**
     * 是否团购券，1是0否
     */
    @ApiModelProperty(name = "isGroupPurchase", value = "是否团购券，1是0否")
    private Integer isGroupPurchase;

    /**
     * 团购价格
     */
    @ApiModelProperty(name = "groupPurchasePrice", value = "团购价格")
    private BigDecimal groupPurchasePrice;

    /**
     * 有效期类型,-1 永久可用，1固定日期，2动态时期
     */
    @ApiModelProperty(name = "validityType", value = "有效期类型,-1永久可用，1固定日期，2动态时期")
    private Integer validityType;

    /**
     * 动态日期配置{"afterDate":"1","day":"2"}
     */
    @ApiModelProperty(name = "dynamicDate", value = "动态日期配置{\"afterDate\":\"1\",\"day\":\"2\"}")
    private String dynamicDate;

    /**
     * 描述
     */
    @ApiModelProperty(name = "remark", value = "描述")
    private String remark;

    /**
     * 规则说明
     */
    @ApiModelProperty(name = "ruleExplain", value = "规则说明")
    private String ruleExplain;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 是否生成券码
     */
    @ApiModelProperty(name = "isGenerateCode", value = "是否生成券码")
    private String isGenerateCode;

    /**
     * 成本中心
     */
    @ApiModelProperty(name = "issueDept", value = "成本中心")
    private String issueDept;

    /**
     * 公司代码
     */
    @ApiModelProperty(name = "bukrs", value = "公司代码")
    private String bukrs;

    /*
     *  是否与门店促销互斥，1是0否
     */
    @ApiModelProperty(name = "isStoreMutex", value = "是否与门店促销互斥，1是0否")
    private Integer isStoreMutex;

    /**
     * OA申请人工号
     */
    @ApiModelProperty(name = "applicantNo", value = "OA申请人工号")
    private String applicantNo;

    /**
     * OA申请人姓名
     */
    @ApiModelProperty(name = "applicantName", value = "OA申请人姓名")
    private String applicantName;

    /**
     * 会员id
     */
    @ApiModelProperty(name = "会员id", value = "会员id")
    private Long memberId;

    /**
     * 精准营销活动id
     */
    @ApiModelProperty(name = "精准营销活动id", value = "精准营销活动id")
    private String activityGroupCode;

    /**
     * 当前会员已领取数量
     */
    @ApiModelProperty(name = "会员已领取数量", value = "会员已领取数量")
    private Long receiveNum;

    /**
     * 券范围类型：10=平台券，20=店铺券
     */
    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    private Integer couponRange;

    /**
     * 商家id
     */
    @ApiModelProperty(name = "sellerId", value = "所属商家id")
    private Long sellerId ;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "所属店铺id")
    private Long shopId ;

    /**
     * 在营销优惠券活动中到可领取数量
     */
    @ApiModelProperty(name = "limitQty", value = "在营销优惠券活动中到可领取数量")
    private Integer limitQty;

    @ApiModelProperty(name = "remainingLimitQty", value = "用户剩余可领取总数")
    private Integer remainingLimitQty;

    /**
     * 用户每日可领取数量限制
     */
    @ApiModelProperty(name = "dayLimitQty", value = "用户每日可领取数量限制")
    private Integer dayLimitQty;

    @ApiModelProperty(name = "remainingDayLimitQty", value = "用户每日剩余可领取数量")
    private Integer remainingDayLimitQty;

    @ApiModelProperty(
            name = "itemRange",
            value = "商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）"
    )
    private String itemRange;

    @ApiModelProperty(name = "shopRangeType", value = "店铺范围取值：10=所有店铺，20=线上店铺，30=线下店铺，60=部分店铺，70=排除部分店铺")
    private Integer shopRangeType;

    @ApiModelProperty(name = "couponShopList", value = "优惠券店铺集合")
    private List<CouponTemplateShopDto> couponShopList;

    @ApiModelProperty(name = "couponItemList", value = "优惠券商品集合")
    private List<CouponTemplateItemDto> couponItemList;

    @ApiModelProperty(name = "couponTemplateCatalogDtoList", value = "优惠券商品类别集合")
    private List<Long> couponTemplateCatalogDtoList;

    @ApiModelProperty(name = "couponTemplateBrandDtoList", value = "优惠券商品品牌集合")
    private List<CouponTemplateBrandDto> couponTemplateBrandDtoList;

    /**
     * 满减（满折）条件
     */
    @ApiModelProperty(name = "couponMoneyOffDto", value = "满减（满折）条件 ")
    private CouponMoneyOffDto couponMoneyOffDto;

    private String extension;

    @ApiModelProperty(name = "isBuyType", value = "是否需要购买 0 否 1 是")
    private Integer isBuyType;
    @ApiModelProperty(name = "buyAmount", value = "购买金额")
    private String buyAmount;
    @ApiModelProperty(name = "isGif", value = "是否支持转赠,0默认否 1支持")
    private Integer isGif;

    @ApiModelProperty(name = "personalizedCouponRespDto", value = "个性化条件")
    private PersonalizedCouponRespDto personalizedCouponRespDto;

    @ApiModelProperty(name = "couponPieceGiftRespDtos", value = "商品满赠条件")
    private List<CouponPieceGiftRespDto> couponPieceGiftRespDtos;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "券模板关联的活动标签", value = "活动标签")
    private String activityTag;

    /**
     * 优惠券服务类型（1产品体验 2新品尝鲜 3家电清洗 4家电保养 5.活动入场券
     */
    @ApiModelProperty(name = "serviceType", value = "优惠券服务类型（1产品体验 2新品尝鲜 3家电清洗 4家电保养 5.活动入场券")
    private Integer serviceType;

    public Integer getRemainingLimitQty() {
        return remainingLimitQty;
    }

    public void setRemainingLimitQty(Integer remainingLimitQty) {
        this.remainingLimitQty = remainingLimitQty;
    }

    public Integer getRemainingDayLimitQty() {
        return remainingDayLimitQty;
    }

    public void setRemainingDayLimitQty(Integer remainingDayLimitQty) {
        this.remainingDayLimitQty = remainingDayLimitQty;
    }

    public Integer getServiceType() {
        return serviceType;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public Integer getIsBuyType() {
        return isBuyType;
    }

    public void setIsBuyType(Integer isBuyType) {
        this.isBuyType = isBuyType;
    }

    public String getBuyAmount() {
        return buyAmount;
    }

    public void setBuyAmount(String buyAmount) {
        this.buyAmount = buyAmount;
    }

    public Integer getIsGif() {
        return isGif;
    }

    public void setIsGif(Integer isGif) {
        this.isGif = isGif;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMarketingCode() {
        return marketingCode;
    }

    public void setMarketingCode(String marketingCode) {
        this.marketingCode = marketingCode;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Long getRemainingQuantity() {
        return remainingQuantity;
    }

    public void setRemainingQuantity(Long remainingQuantity) {
        this.remainingQuantity = remainingQuantity;
    }

    public Date getReceiveStartTime() {
        return receiveStartTime;
    }

    public void setReceiveStartTime(Date receiveStartTime) {
        this.receiveStartTime = receiveStartTime;
    }

    public Date getReceiveEndTime() {
        return receiveEndTime;
    }

    public void setReceiveEndTime(Date receiveEndTime) {
        this.receiveEndTime = receiveEndTime;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getIsDirectional() {
        return isDirectional;
    }

    public void setIsDirectional(Integer isDirectional) {
        this.isDirectional = isDirectional;
    }

    public Integer getMutexType() {
        return mutexType;
    }

    public void setMutexType(Integer mutexType) {
        this.mutexType = mutexType;
    }

    public Integer getShopType() {
        return shopType;
    }

    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }

    public Integer getPurpose() {
        return purpose;
    }

    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    public String getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public Integer getIsGroupPurchase() {
        return isGroupPurchase;
    }

    public void setIsGroupPurchase(Integer isGroupPurchase) {
        this.isGroupPurchase = isGroupPurchase;
    }

    public BigDecimal getGroupPurchasePrice() {
        return groupPurchasePrice;
    }

    public void setGroupPurchasePrice(BigDecimal groupPurchasePrice) {
        this.groupPurchasePrice = groupPurchasePrice;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public String getDynamicDate() {
        return dynamicDate;
    }

    public void setDynamicDate(String dynamicDate) {
        this.dynamicDate = dynamicDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRuleExplain() {
        return ruleExplain;
    }

    public void setRuleExplain(String ruleExplain) {
        this.ruleExplain = ruleExplain;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getIsGenerateCode() {
        return isGenerateCode;
    }

    public void setIsGenerateCode(String isGenerateCode) {
        this.isGenerateCode = isGenerateCode;
    }

    public String getIssueDept() {
        return issueDept;
    }

    public void setIssueDept(String issueDept) {
        this.issueDept = issueDept;
    }

    public String getBukrs() {
        return bukrs;
    }

    public void setBukrs(String bukrs) {
        this.bukrs = bukrs;
    }

    public Integer getIsStoreMutex() {
        return isStoreMutex;
    }

    public void setIsStoreMutex(Integer isStoreMutex) {
        this.isStoreMutex = isStoreMutex;
    }

    public String getApplicantNo() {
        return applicantNo;
    }

    public void setApplicantNo(String applicantNo) {
        this.applicantNo = applicantNo;

    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getActivityGroupCode() {
        return activityGroupCode;
    }

    public void setActivityGroupCode(String activityGroupCode) {
        this.activityGroupCode = activityGroupCode;
    }

    public Long getReceiveNum() {
        return receiveNum;
    }

    public void setReceiveNum(Long receiveNum) {
        this.receiveNum = receiveNum;
    }

    public Integer getLimitQty() {
        return limitQty;
    }

    public void setLimitQty(Integer limitQty) {
        this.limitQty = limitQty;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<CouponTemplateShopDto> getCouponShopList() {
        return couponShopList;
    }

    public void setCouponShopList(List<CouponTemplateShopDto> couponShopList) {
        this.couponShopList = couponShopList;
    }

    public List<CouponTemplateItemDto> getCouponItemList() {
        return couponItemList;
    }

    public void setCouponItemList(List<CouponTemplateItemDto> couponItemList) {
        this.couponItemList = couponItemList;
    }

    public List<Long> getCouponTemplateCatalogDtoList() {
        return couponTemplateCatalogDtoList;
    }

    public void setCouponTemplateCatalogDtoList(List<Long> couponTemplateCatalogDtoList) {
        this.couponTemplateCatalogDtoList = couponTemplateCatalogDtoList;
    }

    public List<CouponTemplateBrandDto> getCouponTemplateBrandDtoList() {
        return couponTemplateBrandDtoList;
    }

    public void setCouponTemplateBrandDtoList(List<CouponTemplateBrandDto> couponTemplateBrandDtoList) {
        this.couponTemplateBrandDtoList = couponTemplateBrandDtoList;
    }

    public CouponMoneyOffDto getCouponMoneyOffDto() {
        return couponMoneyOffDto;
    }

    public void setCouponMoneyOffDto(CouponMoneyOffDto couponMoneyOffDto) {
        this.couponMoneyOffDto = couponMoneyOffDto;
    }

    public Integer getDayLimitQty() {
        return dayLimitQty;
    }

    public void setDayLimitQty(Integer dayLimitQty) {
        this.dayLimitQty = dayLimitQty;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    @Override
    public String getExtension() {
        return extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Integer getShopRangeType() {
        return shopRangeType;
    }

    public void setShopRangeType(Integer shopRangeType) {
        this.shopRangeType = shopRangeType;
    }

    public PersonalizedCouponRespDto getPersonalizedCouponRespDto() {
        return personalizedCouponRespDto;
    }

    public void setPersonalizedCouponRespDto(PersonalizedCouponRespDto personalizedCouponRespDto) {
        this.personalizedCouponRespDto = personalizedCouponRespDto;
    }

    public List<CouponPieceGiftRespDto> getCouponPieceGiftRespDtos() {
        return couponPieceGiftRespDtos;
    }

    public void setCouponPieceGiftRespDtos(List<CouponPieceGiftRespDto> couponPieceGiftRespDtos) {
        this.couponPieceGiftRespDtos = couponPieceGiftRespDtos;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }
}
