package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 优惠券模板商品dto
 * @author li.jundong
 * @date: 2019/7/12 10:30
 */
@ApiModel(value = "CouponTemplateItemDto", description = "优惠券模板商品dto")
public class CouponTemplateItemDto implements Serializable {

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "exclude", value = "不包含")
    private boolean exclude;

    @ApiModelProperty(name = "effective", value = "是否有效")
    private boolean effective;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    public CouponTemplateItemDto() {
    }

    public CouponTemplateItemDto(String itemCode) {
        this.itemCode = itemCode;
    }

    public CouponTemplateItemDto(String itemCode, boolean exclude, boolean effective) {
        this.itemCode = itemCode;
        this.exclude = exclude;
        this.effective = effective;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public boolean isEffective() {
        return effective;
    }

    public void setEffective(boolean effective) {
        this.effective = effective;
    }

    public boolean isExclude() {
        return exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
