/**
 * @(#)CouponTemplateQueryRespDto.java 1.0 2020/10/14
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠券模板查询响应dto
 *
 * @author wu.sheng
 * @date 2020/10/14 19:00
 */
@ApiModel(
        value = "CouponTemplateQueryRespDto",
        description = "优惠券模板查询响应dto"
)
public class CouponTemplateQueryRespDto extends RequestDto {

    /**
     * 优惠券模板id
     */
    @ApiModelProperty(name = "id", value = "优惠券模板id")
    private Long id;

    /**
     * 优惠券模板编号
     */
    @ApiModelProperty(name = "couponCode", value = "优惠券模板编号")
    private String couponCode;

    /**
     * 优惠券模板名称
     */
    @ApiModelProperty(name = "couponName", value = "优惠券模板名称")
    private String couponName;

    /**
     *  有效期类型,1固定日期，2动态时期
     */
    @ApiModelProperty(name = "validityType", value = "有效期类型,1固定日期，2动态时期")
    private Integer validityType;

    /**
     *  动态日期配置{"afterDate":"1","day":"2"}
     */
    @ApiModelProperty(name = "dynamicDate", value = "动态日期配置{\"afterDate\":\"1\",\"day\":\"2\"}")
    private String dynamicDate;

    /**
     * 活动id
     */
    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    /**
     * 优惠券模板状态
     */
    @ApiModelProperty(name = "couponTemplateStatus", value = "优惠券模板状态, 10=已创建, 20=已激活, 30=已停用, 40=已作废")
    private String couponTemplateStatus;

    /**
     * 券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券
     */
    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券")
    private Integer couponCategory;

    /**
     * 优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券, 06=运费券
     */
    @ApiModelProperty(name = "couponType", value = "优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券 06提货券 11个性化优惠券 12服务券")
    private String couponType;

    /**
     * 发放总数量（单位：张）
     */
    @ApiModelProperty(name = "totalIssueQuantity", value = "发放总数量（单位：张）")
    private Long totalIssueQuantity;

    /**
     * 面值（单位：元或百分比）
     */
    @ApiModelProperty(name = "couponValue", value = "面值（单位：元或百分比）")
    private BigDecimal couponValue;


    /**
     * 金额阈值，当达到该阈值，才能使用券
     */
    @ApiModelProperty(name = "couponName", value = "金额阈值，当达到该阈值，才能使用券")
    private BigDecimal amount;


    /**
     * 券范围类型：10=平台券，20=店铺券
     */
    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    private Integer couponRange;

    /**
     * 商家id
     */
    @ApiModelProperty(name = "sellerId", value = "所属商家id")
    private Long sellerId;


    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopId", value = "所属店铺id")
    private Long shopId;

    /**
     *  生效时间
     */
    @ApiModelProperty(name = "effectiveTime", value = "生效时间")
    private Date effectiveTime;

    /**
     *  失效时间
     */
    @ApiModelProperty(name = "invalidTime", value = "失效时间")
    private Date invalidTime;

    /**
     * 领取开始时间
     */
    @ApiModelProperty(name = "receiveStartTime", value = "领取开始时间")
    private Date receiveStartTime;

    /**
     * 领取截止时间
     */
    @ApiModelProperty(name = "receiveEndTime", value = "领取截止时间")
    private Date receiveEndTime;

    @ApiModelProperty(name = "activityStatus", value = "活动状态")
    private String activityStatus;

    @ApiModelProperty(name = "auditStatus", value = "活动审核状态")
    private String auditStatus;

    @ApiModelProperty(name = "activityTemplateId", value = "活动模板id")
    private Long activityTemplateId;

    @ApiModelProperty(name = "extension", value = "附加字段")
    private String extension;

    private String tag;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public Date getReceiveStartTime() {
        return receiveStartTime;
    }

    public void setReceiveStartTime(Date receiveStartTime) {
        this.receiveStartTime = receiveStartTime;
    }

    public Date getReceiveEndTime() {
        return receiveEndTime;
    }

    public void setReceiveEndTime(Date receiveEndTime) {
        this.receiveEndTime = receiveEndTime;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public String getDynamicDate() {
        return dynamicDate;
    }

    public void setDynamicDate(String dynamicDate) {
        this.dynamicDate = dynamicDate;
    }
}
