package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 优惠券模板
 *
 * @author tuyun
 * @since 2.0.0
 */
public class CouponTemplateResDto extends CommonVo {

    private static final long serialVersionUID = 9208715608696265976L;
    /**
     * 优惠券模板编号
     */
    private Long id;

    /**
     * 优惠券编码
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 备注说明
     */
    private String remark;

    /**
     * 使用渠道（ONLINE：线上渠道、OFFLINE：线下渠道）
     */
    private String channel;

    /**
     * 状态（NEW：草稿、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：驳回）
     */
    private String couponTemplateStatus;

    /**
     * 发放总数量（单位：张）
     */
    private Long totalIssueQuantity;

    /**
     * 剩余库存数量
     */
    private Long remainingQuantity;

    /**
     * 预占数量
     */
    private Long freezeQuantity;

    /**
     * 领取开始时间
     */
    private Date receiveStartTime;
    /**
     * 领取截止时间
     */
    private Date receiveEndTime;
    
    /**
     * 生效时间
     */
    private Date effectiveTime;

    /**
     * 失效时间
     */
    private Date invalidTime;

    /**
     * 面值（单位：元或百分比）
     */
    private BigDecimal couponValue;

    /**
     * 券类型（现金券：CASH、折扣券：DISCOUNT）
     */
    private String couponType;

    /**
     * 是否生成券编码（Y：是、N：否，默认N）
     */
    private String isGenerateCode;

    /**
     * 叠加使用类型（NO：不允许叠加使用、YES_DIF：不同券定义允许叠加使用、YES_DIF_SAME：不同券定义&相同券定义不同的券都允许叠加）
     */
    private String useSuperimposedType;

    /**
     * 是否预生成（提前生成优惠券）
     */
    private String isGenerate;

    /**
     * 商品使用范围（使用范围：ALL：全部商品、PART）
     */
    private String itemRange;

    /**
     * 金额阈值，当达到该阈值，才能使用券
     */
    private BigDecimal amount;

    /**
     * 活动编号
     */
    private Long activityId;

    /**
     * 扩展字段，存放json
     */
    private String extension;

    /**
     * 店铺id
     */
    private Long shopId;

    /**
     * 商户id
     */
    private Long sellerId;

    private String status ;
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Long getRemainingQuantity() {
        return remainingQuantity;
    }

    public void setRemainingQuantity(Long remainingQuantity) {
        this.remainingQuantity = remainingQuantity;
    }

    public Long getFreezeQuantity() {
        return freezeQuantity;
    }

    public void setFreezeQuantity(Long freezeQuantity) {
        this.freezeQuantity = freezeQuantity;
    }

    public Date getReceiveStartTime() {
		return receiveStartTime;
	}

	public void setReceiveStartTime(Date receiveStartTime) {
		this.receiveStartTime = receiveStartTime;
	}

	public Date getReceiveEndTime() {
		return receiveEndTime;
	}

	public void setReceiveEndTime(Date receiveEndTime) {
		this.receiveEndTime = receiveEndTime;
	}

	public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getIsGenerateCode() {
        return isGenerateCode;
    }

    public void setIsGenerateCode(String isGenerateCode) {
        this.isGenerateCode = isGenerateCode;
    }

    public String getIsGenerate() {
        return isGenerate;
    }

    public void setIsGenerate(String isGenerate) {
        this.isGenerate = isGenerate;
    }

    public String getUseSuperimposedType() {
        return useSuperimposedType;
    }

    public void setUseSuperimposedType(String useSuperimposedType) {
        this.useSuperimposedType = useSuperimposedType;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
