package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 优惠券定义信息
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "CouponTemplateShowRespDto", description = "优惠券定义Dto")
public class CouponTemplateShowRespDto extends CommonVo {
    private static final long serialVersionUID = -3796311961527836374L;
    /**
     * 优惠券编号
     */
    @ApiModelProperty(name = "id", value = "优惠券编号")
    private String id;
    /**
     * 优惠券名称
     */
    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    private String couponName;
    /**
     * 发放总数量（单位：张）
     */
    @ApiModelProperty(name = "totalIssueQuantity", value = "发放总数量（单位：张）")
    private Long totalIssueQuantity;
    /**
     * 已发放数量（单位：张）
     */
    @ApiModelProperty(name = "issuedQuantity", value = "已发放数量（单位：张）")
    private Long issuedQuantity;
    /**
     * 面值（单位：元或百分比）
     */
    @ApiModelProperty(name = "couponCode", value = "面值（单位：元或百分比）")
    private BigDecimal couponValue;
    /**
     * 券类型（现金券：CASH、折扣券：DISCOUNT）
     */
    @ApiModelProperty(name = "couponType", value = "券类型（现金券：CASH、折扣券：DISCOUNT）")
    private String couponType;
    /**
     * 是否允许叠加使用（Y：是、N：否）
     */
    @ApiModelProperty(name = "isCanSuperimposed", value = "是否允许叠加使用（Y：是、N：否）")
    private String isCanSuperimposed;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Long getIssuedQuantity() {
        return issuedQuantity;
    }

    public void setIssuedQuantity(Long issuedQuantity) {
        this.issuedQuantity = issuedQuantity;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getIsCanSuperimposed() {
        return isCanSuperimposed;
    }

    public void setIsCanSuperimposed(String isCanSuperimposed) {
        this.isCanSuperimposed = isCanSuperimposed;
    }
}
