package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 个性化优惠券营销传递dto
 * @Author: 可乐
 * @Date: 2019/11/19 16:05
 * @Version: 0.1.0
 */
@ApiModel(value = "PersonalizedCouponMarketingDto", description = "个性化优惠券营销传递dto")
public class PersonalizedCouponMarketingDto extends BaseVo {

    /**
     个性化商品id列表
     */
    @ApiModelProperty(name = "type", value = "个性化商品id列表")
    private String[] items;

    /**
     * 折扣率值
     */
    @ApiModelProperty(name = "discountValue", value = "折扣率值")
    private BigDecimal discountValue;

    /**
     * 有效时间
     */
    @ApiModelProperty(name = "personalizedDate", value = "有效时间")
    private Date personalizedDate;

    /**
     * 面额
     */
    @ApiModelProperty(name = "couponAmt", value = "面额")
    private BigDecimal couponAmt;

    /**
     * 最低消费额
     */
    @ApiModelProperty(name = "leastPayAmt", value = "最低消费额")
    private BigDecimal leastPayAmt;

    public BigDecimal getCouponAmt() {
        return couponAmt;
    }

    public void setCouponAmt(BigDecimal couponAmt) {
        this.couponAmt = couponAmt;
    }

    public BigDecimal getLeastPayAmt() {
        return leastPayAmt;
    }

    public void setLeastPayAmt(BigDecimal leastPayAmt) {
        this.leastPayAmt = leastPayAmt;
    }

    public String[] getItems() {
        return items;
    }

    public void setItems(String[] items) {
        this.items = items;
    }

    public BigDecimal getDiscountValue() {
        return discountValue;
    }

    public void setDiscountValue(BigDecimal discountValue) {
        this.discountValue = discountValue;
    }

    public Date getPersonalizedDate() {
        return personalizedDate;
    }

    public void setPersonalizedDate(Date personalizedDate) {
        this.personalizedDate = personalizedDate;
    }
}
