package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 个性化条件参数
 * @Author: 可乐
 * @Date: 2019/11/19 16:05
 * @Version: 0.1.0
 */
@ApiModel(value = "PersonalizedCouponRespDto", description = "个性化条件参数")
public class PersonalizedCouponRespDto extends BaseVo {

    /**
     * 0=个性化商品
     * 1=个性化折扣
     * 2=个性化有效期
     * 3=个性化商品 + 个性化折扣
     * 4=个性化商品 + 个性化有效期
     * 5=个性化折扣 + 个性化有效期
     * 6=个性化商品 + 个性化折扣 + 个性化有效期
     * 7=个性化最低消费金额
     * 8=个性化面额
     */
    @ApiModelProperty(name = "type", value = "" +
            "0=个性化商品 " +
            "1=个性化折扣 " +
            "2=个性化有效期 " +
            "3=个性化商品 + 个性化折扣 " +
            "4=个性化商品 + 个性化有效期 " +
            "5=个性化折扣 + 个性化有效期 " +
            "6=个性化商品 + 个性化折扣 + 个性化有效期" +
            "7=个性化最低消费金额 " +
            "8=个性化面额 ")
    private Integer type;

    /**
     * 是否包含已购买商品 0 不包含 1包含
     */
    @ApiModelProperty(name = "isContainsBuy", value = "是否包含已购买商品 0 不包含 1包含")
    private Integer isContainsBuy;

    /**
     * 有效商品个数
     */
    @ApiModelProperty(name = "itemNum", value = "有效商品个数")
    private Integer itemNum;

    /**
     * 个性化券券折扣率上限
     */
    @ApiModelProperty("个性化券券折扣率上限")
    private BigDecimal discountMaxRate;
    /**
     * 个性化券券折扣率下限
     */
    @ApiModelProperty("个性化券券折扣率下限")
    private BigDecimal discountMinRate;

    @ApiModelProperty("个性化券折扣策略(0:按折扣敏感度，1：按累计贡献值，2：按黄金购买时间GT值 3：按客单价)")
    private Integer discountTactics;

    /**
     * 个性化券有效期开始时间
     */
    @ApiModelProperty("个性化券有效期开始时间")
    private Date personalizedStartDate;
    /**
     * 个性化券有效期结束时间
     */
    @ApiModelProperty("个性化券有效期结束时间")
    private Date personalizedEndDate;

    @ApiModelProperty("最低消费金额上限（当个性化类型=7时有值，否则为空)")
    private BigDecimal leastPayMaxAmt;
    @ApiModelProperty("最低消费金额下限（当个性化类型=7时有值，否则为空。最低消费金额下限不能低于固定券面额）")
    private BigDecimal leastPayMinAmt;
    @ApiModelProperty("固定券面额(当个性化类型=7时有值，否则为空)")
    private BigDecimal fixedCouponAmt;

    @ApiModelProperty("券面额上限（当个性化类型=8时有值，否则为空。券面额上限不能高于固定最低消费金额）")
    private BigDecimal couponMaxAmt;
    @ApiModelProperty("券面额下限（当个性化类型=8时有值，否则为空）")
    private BigDecimal couponMinAmt;
    @ApiModelProperty("固定最低消费金额（当个性化类型=8时有值，否则为空）")
    private BigDecimal fixedLeastPayAmt;

    @ApiModelProperty("取整间隔（为1~10之间的整数，且不能大于个性化范围上下限之差）")
    private Integer roundInterval;

    public BigDecimal getLeastPayMaxAmt() {
        return leastPayMaxAmt;
    }

    public void setLeastPayMaxAmt(BigDecimal leastPayMaxAmt) {
        this.leastPayMaxAmt = leastPayMaxAmt;
    }

    public BigDecimal getLeastPayMinAmt() {
        return leastPayMinAmt;
    }

    public void setLeastPayMinAmt(BigDecimal leastPayMinAmt) {
        this.leastPayMinAmt = leastPayMinAmt;
    }

    public BigDecimal getFixedCouponAmt() {
        return fixedCouponAmt;
    }

    public void setFixedCouponAmt(BigDecimal fixedCouponAmt) {
        this.fixedCouponAmt = fixedCouponAmt;
    }

    public BigDecimal getCouponMaxAmt() {
        return couponMaxAmt;
    }

    public void setCouponMaxAmt(BigDecimal couponMaxAmt) {
        this.couponMaxAmt = couponMaxAmt;
    }

    public BigDecimal getCouponMinAmt() {
        return couponMinAmt;
    }

    public void setCouponMinAmt(BigDecimal couponMinAmt) {
        this.couponMinAmt = couponMinAmt;
    }

    public BigDecimal getFixedLeastPayAmt() {
        return fixedLeastPayAmt;
    }

    public void setFixedLeastPayAmt(BigDecimal fixedLeastPayAmt) {
        this.fixedLeastPayAmt = fixedLeastPayAmt;
    }

    public Integer getRoundInterval() {
        return roundInterval;
    }

    public void setRoundInterval(Integer roundInterval) {
        this.roundInterval = roundInterval;
    }

    public Integer getType() {
        return type;
    }

    public Integer getDiscountTactics() {
        return discountTactics;
    }

    public void setDiscountTactics(Integer discountTactics) {
        this.discountTactics = discountTactics;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getDiscountMaxRate() {
        return discountMaxRate;
    }

    public void setDiscountMaxRate(BigDecimal discountMaxRate) {
        this.discountMaxRate = discountMaxRate;
    }

    public BigDecimal getDiscountMinRate() {
        return discountMinRate;
    }

    public void setDiscountMinRate(BigDecimal discountMinRate) {
        this.discountMinRate = discountMinRate;
    }

    public Date getPersonalizedStartDate() {
        return personalizedStartDate;
    }

    public void setPersonalizedStartDate(Date personalizedStartDate) {
        this.personalizedStartDate = personalizedStartDate;
    }

    public Date getPersonalizedEndDate() {
        return personalizedEndDate;
    }

    public void setPersonalizedEndDate(Date personalizedEndDate) {
        this.personalizedEndDate = personalizedEndDate;
    }

    public Integer getIsContainsBuy() {
        return isContainsBuy;
    }

    public void setIsContainsBuy(Integer isContainsBuy) {
        this.isContainsBuy = isContainsBuy;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }
}
