/**
 * @(#)PreviewCouponRespDto.java 1.0 2021/3/31
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 优惠券预览参数
 *
 * @author wu.sheng
 * @date 2021/3/31 15:52
 */
@ApiModel(value = "PreviewCouponRespDto", description = "优惠券预览响应Dto")
public class PreviewCouponRespDto extends CouponExtRespDto {

    @ApiModelProperty(name = "status", value = "状态：1可用，0不可用")
    private Integer status;

    @ApiModelProperty(name = "shopList", value = "优惠券适用店铺id列表")
    private List<Long> shopList;

    @ApiModelProperty(name = "unableReason", value = "不可用原因")
    private String unableReason;

    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券")
    private Integer couponCategory;

    @ApiModelProperty(name = "券模板关联的活动标签", value = "券模板关联的活动标签")
    private String activityTag;

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<Long> getShopList() {
        return shopList;
    }

    public void setShopList(List<Long> shopList) {
        this.shopList = shopList;
    }

    public String getUnableReason() {
        return unableReason;
    }

    public void setUnableReason(String unableReason) {
        this.unableReason = unableReason;
    }
}
