package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response;


import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* 营销任务-客户待领取优惠券返回Dto
* @author XIAOXUAN
* @since 2.2.0
*/
@ApiModel(
        value = "TaskCustomerCouponTemplateRespDto",
        description = "客户待领取优惠券返回Dto"
)
public class TaskCustomerCouponTemplateRespDto extends BaseRespDto {

    @ApiModelProperty(
            name = "id",
            value = "id"
    )
    private Long id;

    @ApiModelProperty(
            name = "memberId",
            value = "会员id"
    )
    private Long memberId;

    /**
     *  主动营销id
     */
    @ApiModelProperty(
            name = "taskId",
            value = "主动营销id"
    )
    private Long taskId;

    /**
     *  优惠券模板id
     */
    @ApiModelProperty(
            name = "couponTemplateId",
            value = "优惠券模板id"
    )
    private Long couponTemplateId;

    /**
     * 优惠券推送方式(0：定向推券 1：领券中心-通用 2：领券中心-精准)
     */
    @ApiModelProperty(
            name = "couponPushMethod",
            value = "优惠券推送方式(0：定向推券 1：领券中心-通用 2：领券中心-精准)"
    )
    private Integer couponPushMethod;

    /**
     *  优惠券数量
     */
    @ApiModelProperty(
            name = "count",
            value = "优惠券数量"
    )
    private Integer count;

    /**
     *  1：通用  2：精准(分别一一对应coupon_push_method的1和2)
     */
    @ApiModelProperty(
            name = "type",
            value = "1：通用  2：精准(分别一一对应coupon_push_method的1和2)"
    )
    private Integer type;

    /**
     *  组织部门id(预留)
     */
    @ApiModelProperty(
            name = "orgId",
            value = "组织部门id(预留)"
    )
    private Long orgId;

    /**
     *  扩展
     */
    @ApiModelProperty(
            name = "extension",
            value = "扩展"
    )
    private String extension;


    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Integer getCouponPushMethod() {
        return couponPushMethod;
    }

    public void setCouponPushMethod(Integer couponPushMethod) {
        this.couponPushMethod = couponPushMethod;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}