/*
 * *
 *  * @(#)ICouponApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponCreateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import java.util.List;

/**
 * 优惠券API
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"促销中心:优惠券API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-coupon-service-ICouponApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/coupon", url = "${yundt.cube.center.promotion.api:}")
public interface ICouponApi {

    /**
     * 新增优惠券活动
     *
     * @param couponCreateReqDto 优惠券创建Dto
     * @return 操作结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增优惠券活动", notes = "新增优惠券活动")
    @Deprecated
    RestResponse<Long> addCoupon(@Valid @RequestBody CouponCreateReqDto couponCreateReqDto);

    /**
     * 更新优惠券活动
     *
     * @param id                 优惠券活动ID
     * @param couponCreateReqDto 优惠券更新Dto
     * @return 操作结果
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "更新优惠券活动", notes = "更新优惠券活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "优惠券id", dataType = "Long", paramType = "path",required = true)
    })
    @Deprecated
    RestResponse<String> modifyCoupon(@Min(value = 1, message = "id非法") @PathVariable("id") Long id,
                                    @RequestBody CouponCreateReqDto couponCreateReqDto);

    /**
     * 删除优惠券活动
     *
     * @param id 优惠券活动ID
     * @return 操作结果
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除优惠券活动", notes = "删除优惠券活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "优惠券id", dataType = "Long", paramType = "path",required = true)
    })
    @Deprecated
    RestResponse<String> deleteCoupon(@Min(value = 1, message = "id非法") @PathVariable("id") Long id);

//    /**
//     * 审核通过优惠券活动
//     *
//     * @param id     优惠券活动ID
//     * @return 操作结果
//     */
//    @PostMapping("/verify/pass/{is}")
//    @ApiOperation(value = "审核通过优惠券活动", notes = "审核通过优惠券活动")
//    RestResponse<String> verifyPassCoupon(@Min(value = 1, message = "id非法")@PathVariable("id") Long id);
//
//    /**
//     * 审核拒绝优惠券活动
//     *
//     * @param id     优惠券活动ID
//     * @return 操作结果
//     */
//    @PostMapping("/verify/refuse/{id}")
//    @ApiOperation(value = "审核拒绝优惠券活动", notes = "审核拒绝优惠券活动")
//    RestResponse<String> verifyRefuseCoupon(@Min(value = 1, message = "id非法")@PathVariable("id") Long id);

//    /**
//     * 启用优惠券活动
//     *
//     * @param id     优惠券活动ID
//     * @return 操作结果
//     */
   @PostMapping("/enable/{id}")
   @ApiOperation(value = "启用优惠券活动", notes = "启用优惠券活动")
   @Deprecated
   RestResponse<String> enableCoupon(@Min(value = 1, message = "id非法")@PathVariable("id") Long id);

//    /**
//     * 禁用优惠券活动
//     *
//     * @param id     优惠券活动ID
//     * @return 操作结果
//     */
//    @PostMapping("/disable/{id}")
//    @ApiOperation(value = "禁用优惠券活动", notes = "禁用优惠券活动")
//    RestResponse<String> disableCoupon(@Min(value = 1, message = "id非法")@PathVariable("id") Long id);

//    /**
//     * 释放优惠券
//     *
//     * @param id 优惠券ID
//     * @return
//     */
//    @PostMapping("/release/{id}")
//    @ApiOperation(value = "释放优惠券", notes = "释放优惠券")
//    RestResponse<String> releaseCoupon(@Min(value = 1, message = "id非法") @PathVariable("id") Long id);


    /**
     * 领取优惠券
     *
     * @param couponTemplateIds 模版IDS
     * @param userId
     * @return
     */
    @PostMapping("/receive/couponIds/{couponTemplateIds}/userId/{userId}")
    @ApiOperation(value = "领取优惠券", notes = "领取优惠券【开放给引擎调用的方法，禁止直接调用】")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponTemplateIds", value = "优惠券模板id集合,多个逗号隔开", dataType = "String", paramType = "path",required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", dataType = "Long", paramType = "path",required = true)
    })
    @Deprecated
    RestResponse<List<Long>> receiveCoupons(@PathVariable("couponTemplateIds") List<Long> couponTemplateIds,
                                            @PathVariable("userId") Long userId);


//    /**
//     * 使用优惠券
//     *
//     * @param userId    参与该活动的用户ID
//     * @param couponIds 优惠券ID
//     * @return 优惠数据，key：商品ID，value：优惠金额
//     */
//    @PostMapping("/userId/{userId}/couponIds/{couponIds}")
//    @ApiOperation(value = "使用优惠券", notes = "使用优惠券")
//    RestResponse<String> deductCoupon(@PathVariable("userId") Long userId,
//                                    @PathVariable("couponIds") List<Long> couponIds);

}
