package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.*;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponSendRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponStatisticDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(
        tags = {"促销中心:优惠券定制API"}
)
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-ICouponExtApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/coupon/ext"
)
public interface ICouponExtApi {

    /**
     * 根据id优惠券
     * @author: li.jundong
     * @date: 2019/6/27 11:04
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Void>
     */
    @PutMapping("/{id}/invalid")
    @ApiOperation(
            value = "根据优惠券id查询优惠券详情",
            notes = "根据优惠券id查询优惠券详情"
    )
    RestResponse<Void> invalid(@PathVariable(value = "id") Long id);

    /**
     * 批量作废优惠券
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "根据优惠券ids集合批量作废优惠券", notes = "根据优惠券ids集合批量作废优惠券")
    @PostMapping("/batchInvalid")
    RestResponse<Void> batchInvalid(@RequestBody List<Long> ids);

    /**
     * 批量生成匿名优惠券
     * @author: li.jundong
     * @date: 2019/6/21 16:11
     * @param: * @param couponBatchCreateReqDto
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Long>
     */
    @PostMapping("/create")
    @ApiOperation(
            value = "条件批量生成匿名优惠券",
            notes = "根据条件批量生成匿名优惠券"
    )
    RestResponse<String> batchCreate(@RequestBody CouponBatchCreateReqDto couponBatchCreateReqDto);

    /**
     * 优惠券发放（手工领取），主动领取(弃用)
     *
     * @param couponSendReqDto
     * @return
     */
    @ApiOperation(value = "优惠券发放（手工领取）", notes = "优惠券发放（手工领取）")
    @PostMapping("/receiveCoupon")
    @Deprecated
    RestResponse<CouponSendRespDto> receiveCoupon(@RequestBody CouponSendReqDto couponSendReqDto);

    /**
     * 优惠券发放（拼团券），拼购成功后发券(LP专用)
     *
     * @param couponSendReqDto
     * @return
     */
    @ApiOperation(value = "优惠券发放（拼团券）", notes = "优惠券发放（拼团券）")
    @PostMapping("/spellCoupon")
    @Deprecated
    RestResponse<CouponSendRespDto> spellCoupon(@RequestBody CouponSendReqDto couponSendReqDto);

    /**
     * 优惠券发放（系统推券），后台系统发放
     *
     * @param couponBatchSendReqDto
     * @return
     */
    @ApiOperation(value = "优惠券发放（内部使用,使用方自判断库存来避免多次无用的调用）", notes = "（内部使用,使用方自判断库存来避免多次无用的调用）")
    @PostMapping("/pushCoupon")
    RestResponse<CouponPushRespDto> pushCoupon(@RequestBody CouponBatchSendReqDto couponBatchSendReqDto);


    /**
     * 优惠券批量推送,(对于大批量推送优惠券场景,提供出新的接口,增加库存判断机制,不需要走引擎去判断库存,提高效率)
     *
     * @param couponBatchSendReqDto
     * @return
     */
    @ApiOperation(value = "优惠券发放（外部使用-对于大批量推送优惠券场景,提供出新的接口,增加库存判断机制,不需要走引擎去判断库存,提高效率）", notes = "优惠券发放（外部使用）-对于大批量推送优惠券场景,提供出新的接口,增加库存判断机制,不需要走引擎去判断库存,提高效率")
    @PostMapping("/pushCoupon/external")
    RestResponse<CouponPushRespDto> pushCouponByExternal(@RequestBody CouponBatchSendReqDto couponBatchSendReqDto);


    /**
     * 个人领券（商城），用户主动领券
     *
     * @param couponBatchSendReqDto
     * @return
     */
    @ApiOperation(value = "个人领券（商城），用户主动领券", notes = "个人领券（商城），用户主动领券")
    @PostMapping("/reviceCoupon2C")
    RestResponse<CouponPushRespDto> reviceCoupon2C(@RequestBody CouponBatchSendReqDto couponBatchSendReqDto);

    /**
     * 优惠券冲正（根据券编码进行冲正）
     *
     * @param couponReleaseReqDto
     * @return
     */
    @ApiOperation(value = "优惠券冲正（根据优惠券编码进行冲正）", notes = "优惠券冲正（根据券编码进行冲正）")
    @PostMapping("/releaseCoupon")
    RestResponse<Boolean> releaseCoupon(@RequestBody CouponReleaseReqDto couponReleaseReqDto);

    /**
     * 券支付冲正（根据支付流水进行冲正）
     *
     * @param couponReleaseReqDto
     * @return
     */
    @ApiOperation(value = "券支付冲正（根据支付编号进行冲正）", notes = "券支付冲正（根据支付编号进行冲正）")
    @PostMapping("/releaseCouponByPaymentCode")
    RestResponse<Boolean> releaseCouponByPaymentCode(@RequestBody CouponReleaseReqDto couponReleaseReqDto);

    /**
     * 优惠券核销(LP专用)
     *
     * @param couponUseReqDto 核销信息
     * @return
     */
    @ApiOperation(value = "优惠券核销", notes = "优惠券核销")
    @PostMapping("/useCoupon")
    @Deprecated
    RestResponse<List<CouponExtRespDto>> useCoupon(@RequestBody CouponUseReqDto couponUseReqDto);

    /**
     * 券使用总览统计
     *
     * @param couponStatisticReqDto 券使用总览请求dto
     * @return
     */
    @ApiOperation(value = "券使用总览统计", notes = "券使用总览统计")
    @PostMapping("/statisticCoupon")
    RestResponse<CouponStatisticDto> statisticCoupon(@RequestBody CouponStatisticReqDto couponStatisticReqDto);

    /**
     * 导出券使用总览统计
     *
     * @param couponStatisticReqDto 券使用总览请求dto
     * @return
     */
    @ApiOperation(value = "导出券使用总览统计", notes = "导出券使用总览统计")
    @PostMapping("/exportStatisticCoupon")
    RestResponse<String> exportStatisticCoupon(@RequestBody CouponStatisticReqDto couponStatisticReqDto);

    /**
     * 作废优惠券
     *
     * @param couponReleaseReqDto
     * @return
     */
    @ApiOperation(value = "根据条件作废优惠券", notes = "根据条件作废优惠券")
    @PostMapping("/invalidCoupon")
    RestResponse<Boolean> invalidCoupon(@RequestBody CouponReleaseReqDto couponReleaseReqDto);

    @ApiOperation(value = "根据外部订单编号outerOrderCode回滚优惠券", notes = "根据outerOrderCode回滚优惠券")
    @PostMapping("/reverseByOuterOrderCode")
    RestResponse<List<CouponExtRespDto>> reverseByOuterOrderCode(@RequestBody CouponReleaseReqDto couponReleaseReqDto);

    @ApiOperation(value = "根据文件路径 优惠券导入批量作废", notes = "根据文件路径 优惠券导入批量作废")
    @PostMapping("/import/file/invalid")
    RestResponse<Void> importFileInvalid(@RequestParam("fileUrl") String fileUrl);

    @ApiOperation(value = "作废优惠券", notes = "作废优惠券")
    @PostMapping("/invalid")
    RestResponse<Void> invalid(@RequestBody CouponInvalidReqDto couponInvalidReqDto);

    @ApiOperation(value = "会员转移券", notes = "会员转移券")
    @PostMapping("/shift/{userId1}/{userId2}")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId1", value = "新的会员id", dataType = "Long", paramType = "query",required = true),
            @ApiImplicitParam(name = "userId2", value = "旧的会员id", dataType = "Long", paramType = "query",required = true)
    })
    RestResponse<Boolean> shift(@PathVariable("userId1") Long userId1, @PathVariable("userId2") Long userId2);

    @ApiOperation(value = "优惠券转赠", notes = "优惠券转赠")
    @PostMapping("/gif")
    RestResponse couponGif(@Valid @RequestBody CouponGifReqDto dto);

    /**
     * 新增优惠券与个性化计算结果 关联(包括商品/折扣)
     * @return
     */
    @ApiOperation(value = "新增优惠券与个性化计算结果 关联(包括商品/折扣)", notes = "新增优惠券与个性化计算结果 关联(包括商品/折扣)")
    @PostMapping("/add/prsn/ref")
    RestResponse<Void> addPrsnRefByCouponCode(@RequestBody List<PersonalizeCouponRefReqDto> personalizeCouponRefReqDtos);

}
