package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponPackReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Api(
        tags = {"促销中心:券包API"}
)
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-ICouponPackApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/coupon/pack"
)
public interface ICouponPackApi {

    /**
     * 新增券包
     */
    @PostMapping("")
    @ApiOperation(
            value = "新增券包",
            notes = "新增券包"
    )
    RestResponse<Long> addCouponPack(@Valid @RequestBody CouponPackReqDto couponPackReqDto);


    @PutMapping("/{id}")
    @ApiOperation(
            value = "根据ID编辑优惠券包",
            notes = "根据ID编辑优惠券包"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "券包id", dataType = "long", paramType = "path")
           })
    RestResponse<Void> editCouponPack(@PathVariable("id") Long id, @RequestBody CouponPackReqDto couponPackReqDto);


    @DeleteMapping("/{id}")
    @ApiOperation(
            value = "根据ID删除优惠券包",
            notes = "根据ID删除优惠券包"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "券包id", dataType = "long", paramType = "path")
    })
    RestResponse<Void> deleteById(@PathVariable("id") Long id);


    @PutMapping("/status/{id}")
    @ApiOperation(
            value = "根据ID修改优惠券包状态",
            notes = "根据ID修改优惠券包状态"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "券包id", dataType = "long", paramType = "path"),
            @ApiImplicitParam(name = "status", value = "券包状态 1=已激活, 0=已停用", dataType = "int", paramType = "query")
    })
    RestResponse<Void> updateStatusById(@PathVariable("id") Long id, @RequestParam("status") Integer status);




}
