package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 优惠券模板
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:优惠券模版管理接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-coupon-service-ICouponTemplateApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/coupon-template", url = "${yundt.cube.center.promotion.api:}")
public interface ICouponTemplateApi {

    /**
     * 创建优惠券模板
     *
     * @param couponTemplateReqDto 优惠券基本信息
     * @param itemIds              可以使用的商品范围配置信息，如果为null，则不需要限制商品使用范围
     * @param userIds              指定用户发放优惠券，如果为null，则不限制用户范围
     * @return
     */
    @PostMapping("")
    @ApiOperation(value = "创建优惠券模版", notes = "创建优惠券模版")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponTemplateReqDto", value = "模版内容", dataType = "CouponTemplateReqDto", paramType = "body"),
            @ApiImplicitParam(name = "itemIds", value = "可使用该优惠券的商品集（覆盖式更新）"),
            @ApiImplicitParam(name = "userIds", value = "可领取该优惠券的用户集（覆盖式更新）")
    })
    @Deprecated
    RestResponse<Long> createCouponTemplate(@Valid @RequestBody CouponTemplateReqDto couponTemplateReqDto,
                                            @RequestParam(name = "itemIds", required = false) List<Long> itemIds,
                                            @RequestParam(name = "userIds", required = false) List<Long> userIds);

    /**
     * 修改优惠券模板
     *
     * @param id                   模版ID
     * @param couponTemplateReqDto
     * @param itemIds              全覆盖式更新
     * @param userIds              全覆盖式更新
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "修改优惠券模版", notes = "修改优惠券模版")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponTemplateReqDto", value = "模版内容"),
            @ApiImplicitParam(name = "itemIds", value = "可使用该优惠券的商品集（覆盖式更新）"),
            @ApiImplicitParam(name = "userIds", value = "可领取该优惠券的用户集（覆盖式更新）")
    })
    @Deprecated
    RestResponse<String> modifyCouponTemplate(@PathVariable("id") long id,
                                            @RequestBody CouponTemplateReqDto couponTemplateReqDto,
                                            @RequestParam(name = "itemIds", required = false) List<Long> itemIds,
                                            @RequestParam(name = "itemIds", required = false) List<Long> userIds);

    /**
     * 修改优惠券模板状态
     *
     * @param couponTemplateId
     * @param couponTemplateStatus
     * @return
     */
    @Deprecated
    @PutMapping("/{couponTemplateId}/status/{couponTemplateStatus}")
    @ApiOperation(value = "修改优惠券模版状态", notes = "修改优惠券模版状态")
    RestResponse<String> modifyCouponTemplateStatus(@PathVariable("couponTemplateId") long couponTemplateId,
                                                  @PathVariable("couponTemplateStatus") AuditStatusEnum couponTemplateStatus);

    /**
     * 删除优惠券模板
     *
     * @param couponTemplateId
     * @return
     */
    @DeleteMapping("/{couponTemplateId}")
    @ApiOperation(value = "根据优惠券模板id删除优惠券模版（逻辑）", notes = "删除优惠券模版（逻辑）")
    @Deprecated
    RestResponse<String> removeCouponTemplate(@PathVariable("couponTemplateId") long couponTemplateId);

    /**
     * 禁用该优惠价模版
     * @param couponTemplateId 模版ID
     * @return void
     */
    @PutMapping("disable/{couponTemplateId}")
    @ApiOperation(value = "根据优惠券模板id禁用该优惠价模版", notes = "禁用该优惠价模版")
    @Deprecated
    RestResponse<String> disable(@PathVariable("couponTemplateId") long couponTemplateId);

    /**
     * 启用该优惠价模版
     * @param couponTemplateId 模版ID
     * @return void
     */
    @PutMapping("enable/{couponTemplateId}")
    @ApiOperation(value = "根据优惠券模板id启用该优惠价模版", notes = "启用该优惠价模版")
    @Deprecated
    RestResponse<String> enable(@PathVariable("couponTemplateId") long couponTemplateId);
}
