package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateCreateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateDelayReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateUpdateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.TaskCustomerCouponTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(tags = {"促销中心:优惠券模板定制API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-ICouponTemplateExtApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/couponTemplate/ext"
)
public interface ICouponTemplateExtApi {

    /**
     * 新增优惠券活动
     * @author: li.jundong
     * @date: 2019/6/20 15:07
     * @param: * @param couponTemplateCreateExtReqDto
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Long>
     */
    @PostMapping("")
    @ApiOperation(
            value = "新增优惠券活动",
            notes = "新增优惠券活动"
    )
    RestResponse<Long> addCouponTemplate(@Valid @RequestBody CouponTemplateCreateExtReqDto couponTemplateCreateExtReqDto);

    /**
     * 编辑优惠券活动
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "根据优惠券模板id编辑优惠券活动", notes = "编辑优惠券活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "优惠券模板id", dataType = "Long", paramType = "path",required = true),
            @ApiImplicitParam(name = "ActivityCreateReqDto", value = "活动商品DTO", dataType = "CouponTemplateCreateExtReqDto", paramType = "body", required = true)
    })
    RestResponse<Void> modifyCouponTemplateById(@PathVariable(name = "id") Long id,
                                    @Valid @RequestBody CouponTemplateCreateExtReqDto dto);

    @PostMapping("/sync")
    @ApiOperation(
            value = "外部优惠券模板同步",
            notes = "外部优惠券模板同步"
    )
    @Deprecated
    RestResponse<List<CouponTemplateExtRespDto>> syncCouponTemplate(@Valid @RequestBody String json);

    /**
     * 编辑优惠券模板
     * @author: li.jundong
     * @date: 2019/6/27 19:50
     * @param: * @param couponTemplateUpdateExtReqDto
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Long>
     */
    @PutMapping("/edit")
    @ApiOperation(
            value = "编辑优惠券模板",
            notes = "编辑优惠券模板"
    )
    RestResponse<Void> editCouponTemplate(@Valid @RequestBody CouponTemplateUpdateExtReqDto couponTemplateUpdateExtReqDto);

    /**
     * 作废优惠券模板
     * @author: li.jundong
     * @date: 2019/6/21 15:42
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Void>
     */
    @PutMapping("/{id}/invalid")
    @ApiOperation(
            value = "根据模板id作废优惠券模板",
            notes = "根据模板id作废优惠券模板"
    )
    RestResponse<Void> invalid(@PathVariable(value = "id") Long id);

    /**
     * 启用/停用优惠券模板
     * @author: li.jundong
     * @date: 2019/6/21 15:56
     * @param: * @param id
     * @param status
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Void>
     */
    @PutMapping("/{id}/status/{status}")
    @ApiOperation(
            value = "根据模板id启用/停用优惠券模板",
            notes = "根据模板id启用/停用优惠券模板"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "优惠券模板id", dataType = "Long", paramType = "path",required = true),
            @ApiImplicitParam(name = "status", value = "状态（ENABLE：启用、DISABLE：停用", dataType = "String", paramType = "path",required = true)
    })
    RestResponse<Void> setStatus(@PathVariable(value = "id") Long id,
                                 @PathVariable(value = "status") String status);

    @PutMapping("/delay")
    @ApiOperation(
            value = "根据条件优惠券模板延期",
            notes = "根据条件优惠券模板延期"
    )
    RestResponse<Void> delay(@RequestBody CouponTemplateDelayReqDto couponTemplateDelayReqDto);

    /**
     * 批量激活优惠券模板
     * @author: li.jundong
     * @date: 2019/6/28 16:37
     * @param: * @param
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Void>
     */
    @PutMapping("/activate")
    @ApiOperation(
            value = "根据优惠券模板id集合 批量激活优惠券模板",
            notes = "根据优惠券模板id集合 批量激活优惠券模板"
    )
    RestResponse<Void> batchActivate(@Valid @RequestBody List<Long> ids);

    /**
     * 删除优惠券模板
     * @author: li.jundong
     * @date: 2019/6/28 16:37
     * @param: * @param
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Void>
     */
    @DeleteMapping("/{id}")
    @ApiOperation(
            value = "根据优惠券模板id删除优惠券模板",
            notes = "根据优惠券模板id删除优惠券模板"
    )
    RestResponse<Void> delete(@PathVariable(value = "id") Long id);

    /**
     * 初始化优惠券库存
     * @author: li.jundong
     * @date: 2019/7/4 17:35
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Void>
     */
    @PutMapping("/init/stock")
    @ApiOperation(
            value = "初始化优惠券库存",
            notes = "初始化优惠券库存"
    )
    RestResponse<Void> initStock();


    /**
     * 新增待领取优惠券列表---简称领券中心
     * @author: li.jundong
     * @date: 2019/6/20 15:07
     * @param: * @param couponTemplateCreateExtReqDto
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Long>
     */
    @PostMapping("/cust/tmpl")
    @ApiOperation(
            value = "新增会员待领取优惠券列表----领券中心的发放",
            notes = "新增会员待领取优惠券列表----领券中心的发放"
    )
    RestResponse<Long> addCustTmplByMember(@RequestBody List<TaskCustomerCouponTemplateReqDto> taskCustomerCouponTemplateReqDtos);



    /**
     * 根据主动营销id删除待领取优惠券列表(内部使用)
     * @author: li.jundong
     * @date: 2019/6/20 15:07
     * @param: * @param couponTemplateCreateExtReqDto
     * @return:com.dtyunxi.rest.RestResponse<java.lang.Long>
     */
    @DeleteMapping("/cust/tmpl/{taskId}")
    @ApiOperation(
            value = "根据主动营销id删除待领取优惠券列表(内部使用)",
            notes = "根据主动营销id删除待领取优惠券列表(内部使用)"
    )
    @Deprecated
    RestResponse<Void> deleteCustTmplByTaskId(@PathVariable(value = "taskId") Long taskId);

}
