package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 优惠券模版缓存管理接口
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:优惠券模版缓存管理接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-coupon-service-ICouponTemplateStockApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v1/couponTemplate/stock", url = "${yundt.cube.center.promotion.api:}")
public interface ICouponTemplateStockApi {


    /**
     * 根据优惠券模板获取可用库存
     * @param couponTemplateId 模版ID
     * @return void
     */
    @PutMapping("/getAvailableStock/{couponTemplateId}")
    @ApiOperation(value = "根据优惠券模板id获取可用库存", notes = "根据优惠券模板id获取可用库存")
    RestResponse<Long> getAvailableStock(@PathVariable("couponTemplateId") long couponTemplateId);
}
