package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.ItemsReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author chen.fangliang
 * @date 2019/7/11 14:03
 */
@Api(tags = {"促销中心:商品增删改服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-IItemsApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/item",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IItemsApi {

    /**
     * 单条插入,code必传
     *
     * @param reqDto 插入请求
     * @return 成功插入的条数
     */
    @PostMapping({""})
    @ApiOperation(value = "新增商品信息单条插入", notes = "单条插入,code必传")
    RestResponse<Long> add(@RequestBody ItemsReqDto reqDto);

    /**
     * 批量插入，code必传
     *
     * @param batchReq 批量插入请求
     * @return void
     */
    @PostMapping({"/batch"})
    @ApiOperation(value = "新增商品,批量插入", notes = "批量插入,code必传")
    RestResponse<Void> addBatch(@RequestBody List<ItemsReqDto> batchReq);

    /**
     * 根据id单条修改
     *
     * @param reqDto reqDto
     * @return void
     */
    @PutMapping({"/id"})
    @ApiOperation(value = "根据商品id单条修改", notes = "根据id单条修改")
    RestResponse<Void> modifyById(@RequestBody ItemsReqDto reqDto);

    /**
     * 根据code单条修改
     *
     * @param reqDto reqDto
     * @return void
     */
    @PutMapping({"/code"})
    @ApiOperation(value = "根据商品code单条修改", notes = "根据code单条修改")
    RestResponse<Void> modifyByCode(@RequestBody ItemsReqDto reqDto);

    /**
     * 批量修改
     *
     * @param batchReq 批量更新请求
     * @return void
     */
    @PutMapping({"/code/batch"})
    @ApiOperation(value = "根据多个商品code批量修改", notes = "根据code批量修改")
    RestResponse<Void> modifyBatchByCode(@RequestBody List<ItemsReqDto> batchReq);

    /**
     * 根据id更新或者插入
     *
     * @param reqDto dto
     * @return void
     */
    @PutMapping({"/saveOrUpd"})
    @ApiOperation(value = "根据商品id更新或者插入", notes = "根据商品id更新或者插入(有id则是修改操作)")
    RestResponse<Void> saveOrUpdateById(@RequestBody ItemsReqDto reqDto);

    /**
     * 根据id批量更新或者插入
     *
     * @param batchReq batchDto
     * @return void
     */
    @PutMapping({"/saveOrUpd/batch"})
    @ApiOperation(value = "根据商品id批量更新或者插入", notes = "根据id批量更新或者插入")
    RestResponse<Void> saveOrUpdateBatchById(@RequestBody List<ItemsReqDto> batchReq);

    /**
     * 根据code更新或者插入
     *
     * @param reqDto dto
     * @return void
     */
    @PutMapping({"/saveOrUpd/code"})
    @ApiOperation(value = "根据code更新或者插入", notes = "根据code更新或者插入")
    RestResponse<Void> saveOrUpdateByCode(ItemsReqDto reqDto);

    /**
     * 根据code批量更新或者插入
     *
     * @param batchReq batchDto
     * @return void
     */
    @PutMapping({"/saveOrUpd/code/batch"})
    @ApiOperation(value = "根据商品code批量更新或者插入", notes = "根据code批量更新或者插入,如果根据code查询到商品  则是修改操作")
    RestResponse<Void> saveOrUpdateBatchByCode(List<ItemsReqDto> batchReq);

    /**
     * 根据ids批量删除
     *
     * @param ids 商品id集合
     * @return void
     */
    @DeleteMapping({"/delete"})
    @ApiOperation(value = "根据商品ids批量删除", notes = "根据ids批量删除, 物理删除")
    RestResponse<Void> deleteByIds(@RequestBody List<Long> ids);

    /**
     * 根据code批量删除
     *
     * @param codes 商品code集合
     * @return void
     */
    @DeleteMapping({"/delete/code"})
    @ApiOperation(value = "根据商品code批量删除", notes = "根据code批量删除, 物理删除")
    RestResponse<Void> deleteByCode(@RequestBody List<String> codes);

}
