package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = {"促销中心:优惠券定制查询API"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-query-ICouponExtQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/coupon/ext"
)
public interface ICouponExtQueryApi {

    /**
     * 根据条件查询优惠券分页列表
     *
     * @param pageNum
     * @param pageSize
     * @author: li.jundong
     * @date: 2019/6/24 16:34
     * @param: * @param filter
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.biz.marketing.dto.response.CouponExtRespDto>
     */
    @GetMapping("/list")
    @ApiOperation(
            value = "根据条件查询获取优惠券模板分页列表",
            notes = "根据条件查询获取优惠券模板分页列表"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "filter", value = "查询条件,例如:{\"couponName\":\"test\"},可以拼接多个条件,如果没有查询条件则传入{}", dataType = "String", paramType = "query", required = true)
    })
    RestResponse<PageInfo<CouponExtRespDto>> queryByPage(@RequestParam(value = "filter") String filter,
                                                         @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                         @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据条件查询优惠券分页列表， 包含优惠券模板、店铺、商品信息
     *
     * @param pageNum
     * @param pageSize
     * @author: li.jundong
     * @date: 2019/6/24 16:34
     * @param: * @param filter
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.biz.marketing.dto.response.CouponExtRespDto>
     */
    @GetMapping("/listAllInfo")
    @ApiOperation(
            value = "分页获取优惠券模板列表",
            notes = "分页获取优惠券模板列表,返回的dto信息增加商品与赠品"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "filter", value = "查询条件,例如:{\"couponName\":\"test\"},可以拼接多个条件,如果没有查询条件则传入{}", dataType = "String", paramType = "query", required = true)
    })
    RestResponse<PageInfo<CouponExtRespDto>> queryAllInfoByPage(@RequestParam(value = "filter") String filter,
                                                                @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据id获取优惠券详情
     *
     * @author: li.jundong
     * @date: 2019/6/20 16:44
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @GetMapping("/{id}")
    @ApiOperation(
            value = "根据id获取优惠券详情",
            notes = "根据id获取优惠券详情"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "优惠券id", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<CouponExtRespDto> queryById(@PathVariable(value = "id") Long id);

    /**
     * 根据ids获取优惠券详情
     *
     * @author: li.jundong
     * @date: 2019/6/20 16:44
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @PostMapping("/list/ids")
    @ApiOperation(
            value = "根据优惠券ids获取优惠券详情获取优惠券详情",
            notes = "根据优惠券ids获取优惠券详情获取优惠券详情"
    )
    RestResponse<List<CouponExtRespDto>> queryByIds(@RequestBody List<Long> ids);

    /**
     * 根据codes获取优惠券详情
     *
     * @author: li.jundong
     * @date: 2019/6/20 16:44
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @PostMapping("/list/codes")
    @ApiOperation(
            value = "根据优惠券编码codes获取优惠券详情获取优惠券详情",
            notes = "根据优惠券编码codes 获取优惠券详情获取优惠券详情"
    )
    RestResponse<List<CouponExtRespDto>> queryByCodes(@RequestBody List<String> codes);

    /**
     * 根据优惠券编码获取优惠券详情
     *
     * @author: li.jundong
     * @date: 2019/6/20 16:44
     * @param: * @param code
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @GetMapping("/code/{code}")
    @ApiOperation(
            value = "根据优惠券编码获取优惠券详情",
            notes = "根据优惠券编码获取优惠券详情"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "优惠券编码", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<CouponExtRespDto> queryByCode(@PathVariable(value = "code") String code);


    /**
     * 导出优惠券
     *
     * @author: li.jundong
     * @date: 2019/6/21 16:25
     * @param: * @param CouponExtReqDto
     * @return:com.dtyunxi.rest.RestResponse<java.lang.String>
     */
    @PostMapping("/export")
    @ApiOperation(
            value = "根据条件导出优惠",
            notes = "根据条件导出优惠券"
    )
    RestResponse<String> export(@RequestBody String filter);

    /**
     * 导出优惠券功能
     *
     * @param couponReqDto
     * @return
     */
    @PostMapping("/exporCoupon")
    @ApiOperation(
            value = "条件导出优惠券功能，返回下载链接数组",
            notes = "条件导出优惠券功能，返回下载链接数组"
    )
    RestResponse<List<String>> exportCoupon(@RequestBody CouponReqDto couponReqDto);

    /**
     * 校验券导出上传oss是否成功
     *
     * @param fileName
     * @return
     */
    @ApiOperation(
            value = "根据文件名称校验券导出上传oss是否成功",
            notes = "校验券导出上传oss是否成功"
    )
    @GetMapping("/checkExportCoupon")
    RestResponse<Boolean> checkExportCoupon(@RequestParam(value = "fileName") String fileName);

    @GetMapping("/listByOuterOrderCode")
    @ApiOperation(
            value = "根据外部订单号查询优惠券",
            notes = "根据外部订单号查询优惠券"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "memberId", value = "会员id", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "outerOrderCode", value = "外部订单编号", dataType = "String", paramType = "query", required = true)
    })
    RestResponse<List<CouponExtRespDto>> listByOuterOrderCode(@RequestParam(value = "memberId") Long memberId,
                                                              @RequestParam(value = "outerOrderCode") String outerOrderCode);

    /**
     * 查询某用户下的可用优惠券数
     *
     * @param memberId
     * @param couponStatus
     * @return
     */
    @GetMapping("/getAvailableCouponNum")
    @ApiOperation(
            value = "查询某用户下的可用优惠券数",
            notes = "查询某用户下的可用优惠券数"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "memberId", value = "会员id", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "couponStatus", value = "状态（NOT_CONSUMED：未消费、HAS_CONSUMED：已消费、FREEZE：冻结）", dataType = "String", paramType = "query", required = true)
    })
    RestResponse<Integer> getAvailableCouponNum(@RequestParam(value = "memberId") Long memberId, @RequestParam(value = "couponStatus") String couponStatus);

    /**
     * 通过es查询优惠券信息
     *
     * @param couponReqDto 查询条件
     * @return 匹配的优惠券信息
     */
    @GetMapping("/searchData")
    @ApiOperation(
            value = "条件查询优惠券列表(通过es查询优惠券信息)",
            notes = "条件查询优惠券列表(通过es查询优惠券信息)"
    )
    List<CouponExtRespDto> searchData(@SpringQueryMap CouponReqDto couponReqDto);

    @GetMapping("/repeat/use/mq")
    @ApiOperation(
            value = "重发核销MQ",
            notes = "重发核销MQ"
    )
    RestResponse<Void> repeatUseMq(@RequestParam(value = "filter") String filter);


    @GetMapping("/countCouponNum")
    @ApiOperation(value = "根据多个条件统计优惠券数量", notes = "根据多个条件统计优惠券数量")
    RestResponse<Integer> countCouponNum(@SpringQueryMap CouponReqDto reqDto);

    @GetMapping("/personalized/coupon/items")
    @ApiOperation(value = "根据优惠券id或者券码查询个性化优惠券商品范围id列表", notes = "根据优惠券id或者券码查询个性化优惠券商品范围id列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponCode", value = "优惠券-券码", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "couponId", value = "优惠券Id", dataType = "Long", paramType = "query")
    })
    RestResponse<List<Long>> queryPersonalizedCouponItemIds(@RequestParam(value = "couponId", required = false) Long couponId,
                                                            @RequestParam(value = "couponCode", required = false) String couponCode);

    @GetMapping("/list/byTemplate")
    @ApiOperation(value = "获取优惠券模板下的批次列表", notes = "获取优惠券模板下的批次列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponTemplateId", value = "券模板ID", dataType = "Long", paramType = "query", required = true)
    })
    RestResponse<List<CouponBatchRespDto>> listByTemplateId(@RequestParam(value = "couponTemplateId") Long couponTemplateId);


    @GetMapping("/time/use")
    @ApiOperation(value = "按时间范围查询优惠券使用情况报表数据", notes = "按时间范围查询优惠券使用情况报表数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "startTime", value = "优惠券使用的开始时间", dataType = "string", paramType = "query", required = true),
            @ApiImplicitParam(name = "endTime", value = "优惠券使用的开始结束", dataType = "string", paramType = "query", required = true)
    })
    RestResponse<List<CouponRespDto>> queryUseCouponByTime(@RequestParam(value = "startTime") String startTime,
                                                       @RequestParam(value = "endTime") String endTime);


    @ApiOperation(
            value = "分页查询会员可用优惠券列表",
            notes = "分页查询会员的优惠券列表，当前的userId为会员id"
    )
    @GetMapping("/{userId}/coupons")
    RestResponse<PageInfo<CouponExtRespDto>> queryUserCoupons(@PathVariable("userId") Long userId,
                                                         @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                         @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


}
