package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.OrderMatchCouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 订单优惠券相关的api
 * @author li.jundong
 * @date: 2019/7/12 19:16
 */
@Api(tags = {"订单优惠券相关的api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-query-ICouponOrderQueryApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/coupon/ext"
)
public interface ICouponOrderQueryApi {

    /**
     * 下单结算获取可用优惠券
     * @author li.jundong
     * @date 2019/7/12
     * @param orderMatchCouponReqDto
     * @return com.dtyunxi.rest.RestResponse<java.util.List<com.dtyunxi.yundt.cube.biz.marketing.api.coupon.response.CouponExtRespDto>>
     */
    @PostMapping("/order/match")
    @ApiOperation(value = "下单结算获取可用优惠券", notes = "下单结算获取可用优惠券")
    RestResponse<List<CouponExtRespDto>> orderMatch(@RequestBody OrderMatchCouponReqDto orderMatchCouponReqDto);
}
