package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPackRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;


@Api(tags = {"促销中心:券包查询API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-query-ICouponPackQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/coupon/pack"
)
public interface ICouponPackQueryApi {

    @GetMapping("/{id}")
    @ApiOperation(
            value = "根据ID查询优惠券包信息",
            notes = "根据ID查询优惠券包信息"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "券包id", dataType = "long", paramType = "path")
    })
    RestResponse<CouponPackRespDto> queryById(@PathVariable("id") Long id);



    @GetMapping("/page")
    @ApiOperation(
            value = "分页查询券包信息",
            notes = "分页查询券包信息"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "packName", value = "券包名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "packCode", value = "券包编码", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "packType", value = "券包类型1=营销类, 2=权益类, 3=付费类", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "couponTemplateName", value = "优惠券模板名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "券包状态 1=已激活, 0=已停用", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<CouponPackRespDto>> queryPage(@RequestParam(value = "packName",required = false) String packName,
                                                        @RequestParam(value = "packCode",required = false) String packCode,
                                                        @RequestParam(value = "packType",required = false) Integer packType,
                                                        @RequestParam(value = "couponTemplateName",required = false) String couponTemplateName,
                                                        @RequestParam(value = "status",required = false) Integer status,
                                                        @RequestParam(value = "pageNum" ,defaultValue = "1" , required = false) Integer pageNum,
                                                        @RequestParam(value = "pageSize",defaultValue = "10" , required = false) Integer pageSize);
}
