package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.Min;
import java.util.List;

/**
 * 优惠券API
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"促销中心:优惠券API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-coupon-service-query-ICouponQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/coupon", url = "${yundt.cube.center.promotion.api:}")
public interface ICouponQueryApi {

    /**
     * 查询用户优惠券模板下的优惠券计数
     *
     * @param userId
     * @param couponTemplateId
     * @return
     */
    @GetMapping("user-id/{userId}/coupon-template-id/{couponTemplateId}")
    @ApiOperation(value = "查询用户优惠券模板下的优惠券计数", notes = "查询用户优惠券模板下的优惠券计数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", dataType = "Long", paramType = "query",required = true),
            @ApiImplicitParam(name = "couponTemplateId", value = "优惠券ID", dataType = "Long", paramType = "query",required = true)
    })
    RestResponse<Integer> countByConditions(@Min(value = 1, message = "请传入合法的用户ID") @PathVariable("userId") long userId,
                                            @Min(value = 1, message = "请传入合法的优惠券ID") @PathVariable("couponTemplateId") long couponTemplateId);

    /**
     * 查询优惠券活动详情
     *
     * @param id 优惠券活动ID
     * @return 优惠券活动详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据优惠券ID查询优惠券详情", notes = "根据优惠券ID查询优惠券详情")
    RestResponse<CouponRespDto> queryCouponDetail(@Min(value = 1, message = "请传入合法的优惠券ID") @PathVariable("id") long id);

    /**
     * 分页查询优惠券列表
     *
     * @param reqDto   数据过滤条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页优惠券
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查询优惠券列表", notes = "分页查询优惠券列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<CouponQueryRespDto>> queryCouponPage(@SpringQueryMap CouponQueryReqDto reqDto,
                                                               @RequestParam(value = "pageNum", required = false, defaultValue = "1") int pageNum,
                                                               @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize);


    /**
     * 查询用户拥有的优惠券
     *
     * @param userId 用户ID
     * @param couponQueryReqDto 优惠券查询查询dto
     * @return 优惠券列表
     */
    @GetMapping("/userId/{userId}")
    @ApiOperation(value = "查询用户拥有的优惠券", notes = "查询用户拥有的优惠券")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", dataType = "Long", paramType = "query",required = true)
    })
    RestResponse<List<CouponRespDto>> queryUserCouponList(@Min(value = 1, message = "请传入合法的用户ID")
                                                          @PathVariable("userId") Long userId,
                                                          @SpringQueryMap CouponQueryReqDto couponQueryReqDto);

    /**
     * 查询拥有优惠券的用户
     *
     * @param couponTemplateId 优惠券模板Id
     * @return 用户id列表
     */
    @GetMapping("/coupon-template-id/{couponTemplateId}")
    @ApiOperation(value = "查询拥有优惠券的用户", notes = "查询拥有优惠券的用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponTemplateId", value = "优惠券模板id", dataType = "Long", paramType = "path",required = true)
    })
    RestResponse<List<CouponRespDto>> queryUserListByCoupon(@Min(value = 1, message = "请传入合法的优惠券模板ID")
                                                   @PathVariable("couponTemplateId") Long couponTemplateId);

//
//    /**
//     * 根据商品编码集合查询商品
//     *
//     * @param itemIds 商品ID，支持复数
//     * @return 优惠券列表
//     */
//    @GetMapping("/itemIds/{itemIds}")
//    @ApiOperation(value = "查询商品参与的优惠券", notes = "查询商品参与的优惠券活动")
//    RestResponse<List<CouponQueryRespDto>> queryItemCouponList(@NotNull(message = "商品ID不允许为空") @PathVariable String itemIds);
//
//    /**
//     * 根据商品ID和用户ID查询优惠券
//     * 查询该用户是否拥有该商品的优惠券
//     *
//     * @param userId  用户ID
//     * @param itemIds 商品ID，支持复数
//     * @return 该用户该商品拥有的优惠券
//     */
//    @GetMapping("/userId/{userId}/itemIds/{itemIds}")
//    @ApiOperation(value = "根据商品ID和用户ID查询优惠券,查询该用户是否拥有该商品的优惠券", notes = "根据商品ID和用户ID查询优惠券,查询该用户是否拥有该商品的优惠券")
//    RestResponse<List<CouponQueryRespDto>> queryUserCouponByItems(@NotNull(message = "用户ID不允许为空") @PathVariable Long userId,
//                                                                  @NotNull(message = "商品ID不允许为空") @PathVariable String itemIds);

    /**
     * 查询交易可以使用的优惠券
     * <p>
     * 场景：提交订单
     *
     * @param userId    用户编号
     * @param itemIds   订单商品
     * @param couponIds 要使用的优惠券
     * @param amount    金额
     * @return <p>
     * List<CouponRespDto>
     * </p>
     */
    @GetMapping("/user-id/{userId}/item-ids/{itemIds}/coupon-ids/{couponIds}/amount/{amount}")
    @ApiOperation(value = "查询用户交易时可以使用的优惠券", notes = "查询交易可以使用的优惠券")
    RestResponse<List<CouponRespDto>> queryValidCoupon(@PathVariable("userId") long userId,
                                                       @PathVariable("itemIds") List<Long> itemIds,
                                                       @PathVariable("couponIds") List<Long> couponIds,
                                                       @PathVariable("amount") double amount);

}
