package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(
        tags = {"促销中心:优惠券模板定制API"}
)
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-query-ICouponTemplateExtQueryApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/couponTemplate/ext"
)
public interface ICouponTemplateExtQueryApi {

    /**
     * 获取优惠券模板详情
     * @author: li.jundong
     * @date: 2019/6/20 16:17
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @GetMapping("/{id}")
    @ApiOperation(
            value = "根据优惠券模板Id获取优惠券模板详情",
            notes = "根据优惠券模板Id获取优惠券模板详情"
    )
    RestResponse<CouponTemplateExtRespDto> queryById(@PathVariable(value = "id") Long id);

    /**
     * 获取优惠券模板详情
     * @author: li.jundong
     * @date: 2019/6/20 16:17
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @GetMapping("/code/{code}")
    @ApiOperation(
            value = "根据优惠券模板编码获取优惠券模板详情",
            notes = "根据优惠券模板编码获取优惠券模板详情"
    )
    RestResponse<CouponTemplateExtRespDto> queryByCode(@PathVariable(value = "code") String code);

    /**
     * 根据模板编码换取模板id
     * @author: li.jundong
     * @date: 2019/6/20 16:17
     * @param: * @param id
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @GetMapping("/code/temp/{code}")
    @ApiOperation(
            value = "根据模板编码换取模板id",
            notes = "根据模板编码换取模板id"
    )
    RestResponse<Long> queryTempIdByCode(@PathVariable(value = "code") String code);

    /**
     * 优惠券模板列表
     * @author: li.jundong
     * @date: 2019/6/21 15:09
     * @param: * @param filter
     * @param pageNum
     * @param pageSize
     * @return:com.dtyunxi.rest.RestResponse<com.dtyunxi.yundt.cube.center.promotion.api.dto.request.CouponTemplateReqDto>
     */
    @GetMapping("/list")
    @ApiOperation(
            value = "分页条件获取优惠券模板列表",
            notes = "分页条件获取优惠券模板列表"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "filter", value = "查询条件,例如:{\"couponName\":\"test\"},可以拼接多个条件,如果没有查询条件则传入{}", dataType = "String", paramType = "query",required = true)
    })
    RestResponse<PageInfo<CouponTemplateExtRespDto>> queryByPage(@RequestParam(value = "filter") String filter,
                                                                 @RequestParam(value = "pageNum") Integer pageNum,
                                                                 @RequestParam(value = "pageSize") Integer pageSize);

    /**
     * 根据id批量查询优惠券模板
     * @author li.jundong
     * @date 2019/7/17
     * @param ids
     * @return com.dtyunxi.rest.RestResponse<java.util.List<com.dtyunxi.yundt.cube.biz.marketing.api.coupon.response.CouponTemplateExtRespDto>>
     */
    @PostMapping("/ids")
    @ApiOperation(
            value = "根据优惠券模板ids批量获取优惠券模板列表",
            notes = "根据优惠券模板ids批量获取优惠券模板列表"
    )
    RestResponse<List<CouponTemplateExtRespDto>> queryByIds(@Valid @RequestBody List<Long> ids);

    @GetMapping("/code/simple/{code}")
    @ApiOperation(
            value = "根据优惠券模板编码获取优惠券模板详情,只是查单表",
            notes = "根据优惠券模板编码获取优惠券模板详情,只是查单表数据"
    )
    RestResponse<CouponTemplateExtRespDto> queryByCodeSimple(@PathVariable(value = "code") String code);

    @GetMapping("/member/{memberId}/receive/list")
    @ApiOperation(
            value = "通过会员id 查询会员的待领取优惠券模板列表",
            notes = "通过会员id 查询会员的待领取优惠券模板列表"
    )
    RestResponse<List<CouponTemplateExtRespDto>> queryByMemberId(@PathVariable(value = "memberId") Long memberId);

    @PostMapping("/receive/detail")
    @ApiOperation(
            value = "根据优惠券模板编号查询优惠券模板到领取信息",
            notes = "查询优惠券模板到领取信息, activityGroupCode暂未做逻辑, 若填写了activityGroupCode, 在营销优惠券活动中到可领取数量默认为1"
    )
    @ApiImplicitParams({
            @ApiImplicitParam(name = "couponTemplateCode", value = "优惠券模板编码", dataType = "String", paramType = "query",required = true),
            @ApiImplicitParam(name = "activityGroupCode", value = "活动分组编码", dataType = "String", paramType = "query")
    })
    RestResponse<CouponTemplateExtRespDto> queryReceiveDetailByCode(@RequestParam(value = "couponTemplateCode") String couponTemplateCode,
                                                                    @RequestParam(value = "activityGroupCode",required = false) String activityGroupCode);


    @GetMapping("/with-activity")
    @ApiOperation(
            value = "分页条件获取优惠券模板列表",
            notes = "分页条件获取优惠券模板列表"
    )
    RestResponse<PageInfo<CouponTemplateQueryRespDto>> queryWithActivity(@SpringQueryMap CouponTemplateQueryReqDto queryReqDto,
                                                                         @RequestParam(value = "pageNum") Integer pageNum,
                                                                         @RequestParam(value = "pageSize") Integer pageSize);
}
