/*
 * *
 *  * @(#)ICouponTemplateQueryApi.java 2.0.0 18-11-28 下午3:27
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponItemRangeQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponItemRangeRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateResDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShowRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import javax.validation.constraints.Min;
import java.util.List;


/**
 * 优惠券定义
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:优惠券模板"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-coupon-service-query-ICouponTemplateQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/coupon-template", url = "${yundt.cube.center.promotion.api:}")
public interface ICouponTemplateQueryApi {

    /**
     * 查询单品下可以使用的优惠券列表
     * <p>
     * 场景：显示商品明细页
     *
     * @param itemId
     * @return
     */
    @GetMapping("/item/{itemId}")
    @ApiOperation(value = "查询单品下可以使用的优惠券列表", notes = "查询单品下可以使用的优惠券列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "itemId", value = "商品id", dataType = "Long", paramType = "path",required = true)
    })
    @Deprecated
    RestResponse<List<CouponTemplateShowRespDto>> queryCouponTemplatesByItemId(@PathVariable("itemId") Long itemId);


    /**
     * 查询优惠券模板详情
     *
     * @param templateId 模板ID
     * @return
     */
    @GetMapping("/{templateId}")
    @ApiOperation(value = "查询优惠券模板详情", notes = "查询优惠券模板详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板id", dataType = "Long", paramType = "path",required = true)
    })
    @Deprecated
    RestResponse<CouponTemplateResDto> getCouponTemplateById(@PathVariable("templateId") long templateId);
    
    /**
     * 优惠券模板查询
     *
     * @param couponTemplateReqDto 优惠券模板请求dto
     * @return 优惠券
     */
    @GetMapping("/list")
    @ApiOperation(value = "优惠券模板查询", notes = "优惠券模板查询")
    @Deprecated
    RestResponse<List<CouponTemplateResDto>> queryCouponTemplates(@SpringQueryMap CouponTemplateReqDto couponTemplateReqDto);


    /**
     * 获取优惠券模板的商品使用范围
     *
     * @param id 优惠券模板ID
     * @return CouponItemRangeRespDto    商品使用范围
     */
    @GetMapping("/{id}/item-range")
    @ApiOperation(value = "获取优惠券模板的商品使用范围", notes = "获取优惠券模板的商品使用范围")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "优惠券模板ID", dataType = "Long", paramType = "path",required = true)
    })
    @Deprecated
    RestResponse<CouponItemRangeRespDto> queryItemRangeById(@Min(value = 1, message = "请传入合法的优惠券模板ID") @PathVariable("id") Long id);

    /**
     * 根据商品范围反查优惠券列表
     *
     * @param couponItemRangeQueryReqDto 优惠券商品使用范围
     * @return 优惠券模板集合
     */
    @GetMapping("/list/by/item-range")
    @ApiOperation(value = "根据商品范围反查优惠券列表", notes = "根据商品范围反查优惠券列表")
    @Deprecated
    RestResponse<List<CouponTemplateResDto>> queryByItemRange(@SpringQueryMap CouponItemRangeQueryReqDto couponItemRangeQueryReqDto);
}


