package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.ItemsReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ItemsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author chen.fangliang
 * @date 2019/7/11 10:04
 */
@Api(tags = {"促销中心:商品查询服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-query-IItemsQueryApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/item",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IItemsQueryApi {

    /**
     * 根据id查询
     *
     * @param id 主键id
     * @return ItemsRespDto
     */
    @GetMapping({"/{id}"})
    @ApiOperation(value = "根据商品id查询商品详情", notes = "根据id查询条件查询商品详情")
    RestResponse<ItemsRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据code查询(标品的code是唯一的)
     *
     * @param code code
     * @return ItemsRespDto
     */
    @GetMapping({"/code/{code}"})
    @ApiOperation(value = "根据商品编号查询商品详情", notes = "根据code查询条件查询商品详情")
    RestResponse<ItemsRespDto> queryByCode(@PathVariable("code") String code);

    /**
     * 根据条件查询列表
     *
     * @param reqDto ItemsReqDto
     * @return List<ItemsRespDto>
     */
    @GetMapping({"/list"})
    @ApiOperation(value = "条件查询商品列表", notes = "根据条件查询商品列表")
    RestResponse<List<ItemsRespDto>> queryByCondition(@SpringQueryMap ItemsReqDto reqDto);

    /**
     * 分页查询商品信息
     *
     * @param filters  ItemsRespDto
     * @param pageNum  当前页
     * @param pageSize 每页大小
     * @return 分页信息
     */
    @GetMapping({"/page"})
    @ApiOperation(value = "分页查询商品列表", notes = "根据条件分页查询商品列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "filters", value = "查询条件,例如:{\"name\":\"test\"},可以拼接多个条件,如果没有查询条件则传入{}", dataType = "String", paramType = "query",required = true)
    })
    RestResponse<PageInfo<ItemsRespDto>> queryByPage(@RequestParam(name = "filters", required = false, defaultValue = "{}") String filters,
                                                     @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
                                                     @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);

    /**
     * 根据ids查询列表
     *
     * @param ids id集合
     * @return List<ItemsRespDto>
     */
    @PostMapping({"/ids"})
    @ApiOperation(value = "根据商品id集合查询商品列表", notes = "根据商品id集合查询商品列表")
    RestResponse<List<ItemsRespDto>> queryByIds(@RequestBody List<Long> ids);

    /**
     * 根据ids查询列表
     *
     * @param codes id集合
     * @return List<ItemsRespDto>
     */
    @PostMapping({"/codes"})
    @ApiOperation(value = "根据商品code集合查询商品列表", notes = "根据商品code集合查询商品列表")
    RestResponse<List<ItemsRespDto>> queryByCodes(@RequestBody List<String> codes);

    /**
     * 根据商品名称查询编码集合
     *
     * @param itemName
     * @return
     */
    @GetMapping({"/codes/name"})
    @ApiOperation(value = "根据商品名称模糊查询商品列表", notes = "根据商品名称模糊查询商品列表")
    RestResponse<List<String>> queryCodesByName(@RequestParam(value = "itemName") String itemName);

    /**
     * 根据ids查询列表
     *
     * @return List<Integer>
     */
    @GetMapping({"/count"})
    @ApiOperation(value = "全量统计商品总量", notes = "全量统计商品总量")
    RestResponse<Integer> countItem();
}
