/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBaseDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplate4MemberRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * 查询营销发放的优惠券模板服务
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"促销中心:查询营销发放的优惠券模板服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-coupon-service-query-IMarketingCouponQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v1/marketing/coupon", url = "${yundt.cube.center.promotion.api:}")
public interface IMarketingCouponQueryApi{

    /**
     * 查询营销发放给会员的待领取优惠券模板列表
     * @author : 萧玄
     * @Date   : 9:07 2019/7/16
     * @param id
     * @return : com.dtyunxi.rest.RestResponse<java.util.List<com.dtyunxi.yundt.cube.biz.marketing.api.coupon.response.CouponExtRespDto>>
     */
    @GetMapping("/member/{id}/unclaimeds")
    @ApiOperation(value = "根据会员id查询营销发放给会员的待领取优惠券模板列表", notes = "查询营销发放给会员的待领取优惠券模板列表")
    RestResponse<List<CouponTemplate4MemberRespDto>> unclaimedsCouponTemplate4Member(@PathVariable("id") Long id);

    @GetMapping("/{id}")
    @ApiOperation(value = "根据客户待领取优惠券id查询营销发放给会员的待领取优惠券模板信息", notes = "营销任务发放完后,营销会员待领取优惠券列表中的id,查询该优惠券模板的详细信息")
    RestResponse<CouponBaseDto> detail(@PathVariable("id") Long id);
}
