package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.utils;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateShopTypeEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * 店铺类型工具类
 * @author li.jundong
 * @date: 2019/7/22 11:55
 */
public class ShopTypeUtil {

    /**
     * 根据店铺编号，判断门店是线上还是线下
     * @author li.jundong
     * @date 2019/7/22
     * @param shopCode
     * @return java.lang.String
     */
    public static Integer judge(String shopCode){
        if(StringUtils.isBlank(shopCode)){
            return null;
        }
        int i = Integer.parseInt(shopCode);
        if(i >= 3000 && i <= 9999){
            return CouponTemplateShopTypeEnum.OFFLINE_SHOP.getType();
        }else if(i == 1149 || i == 1101){
            return CouponTemplateShopTypeEnum.ONLINE_SHOP.getType();
        }
        return null;
    }
}

