/*
 * *
 *  * @(#)ReturnType.java 2.0.0 7/17/19 4:31 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums;

/**
 * 促销规则中的返还类型
 *
 * @author luo.lei
 * @since 2.0.0
 */
public enum ReturnType {
    POINT(0),
    COUPON(1),
    ITEM(2),
    POSTAGE(3),
    DEPOSIT(4),
    DISCOUNT(5),
    CASH(6),
    ADDITIONAL(7);


    private int type;

    ReturnType(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    public static ReturnType valueOf(int type) {
        switch (type) {
            case 0:
                return POINT;
            case 1:
                return COUPON;
            case 2:
                return ITEM;
            case 3:
                return POSTAGE;
            case 4:
                return DEPOSIT;
            case 5:
                return DISCOUNT;
            case 6:
                return CASH;
            case 7:
                return ADDITIONAL;
            default:
                return null;
        }


    }
}
