/*
 * *
 *  * @(#)Coupon.java 2.0.0 7/17/19 7:03 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠券
 * @author Alex
 *
 */
public class Coupon {

	/**
	 * ze_coupon_id			char	32	0	券号
	 */
	private String		couponId		;
	/**
	 * bu_partner			char	10	0	业务伙伴编号
	 */
	private String		memberId		;
	/**
	 * ze_cpntpt_id			char	10	0	券模板编号
	 */
	private String		cpnTptId		;
	/**
	 * ze_precoupon_id		char	20	0	原券码
	 */
	private String		preCouponId		;
	/**
	 * ze_share_ny			char	1	0	是否分享券(x:定向券 空:分享券)
	 */
	private Boolean		shareNy			;
	/**
	 * ze_sale_ny			char	1	0	是否团购券(x:是 空:否)
	 */
	private Boolean		saleNy			;
	/**
	 * ze_mo_amt			dec	15	2		最低消费金额
	 */
	private BigDecimal	minOrderAmt		;
	/**
	 *ze_cpn_level			char	1	0	使用层级
	 */
	private String		cpnLevel		;
	/**
	 *ze_limit_flag		char	10	0	公用类型
	 */
	private String		limitFlag		;
	/**
	 *ze_store_all			char	10	0	所有店铺适用
	 */
	private String		storeAll		;
	/**
	 *ze_ptoduce_all		char	10	0	所有商品适用
	 */
	private String		produceAll		;
	/**
	 *ze_dc_amt			dec	15	2		金额
	 */
	private BigDecimal	amt				;
	/**
	 *ze_sale_amt			dec	12	2		销售价格
	 */
	private BigDecimal	saleAmt			;
	/**
	 *ze_discount			dec	15	2		折扣
	 */
	private BigDecimal	discount		;
	/**
	 *ze_valid_date		dec	15	0		生效时间
	 */
	private Date		validDate		;
	/**
	 * ze_invalid_date		dec	15	0		失效时间
	 */
	private Date		invalidDate		;
	/**
	 * ze_pmtorder_id		char	30	0	发券订单
	 */
	private String		pmtOrderId		;
	/**
	 *ze_usedodline_id		char	3	0	用券商品行
	 */
	private String		lineId			;
	/**
	 * ze_usedorder_id		char	30	0	用券订单
	 */
	private String		usedOrderId		;
	/**
	 * ze_werks	char		4	0			店铺编号
	 */
	private String		werks			;
	/**
	 * ze_used_time			dec	15	0		用券时间
	 */
	private Date		usedTime		;
	/**
	 * ze_paymentcode		char	38	0	支付编号
	 */
	private String		paymentCode		;
	/**
	 * ze_valid_flag		char	10	0	当前状态
	 */
	private String		validFlag		;
	/**
	 * ze_mark				char	60	0	备注
	 */
	private String		mark			;
	/**
	 * ze_exportdatatimes	dec	4	0		导出次数
	 */
	private Integer		exportDataTimes	;

	public static Coupon newInstance(CouponTemplateExtRespDto coupon) {
		Coupon t = new Coupon();
		t.setCpnTptId(coupon.getId()+"");
		t.setShareNy(coupon.getIsDirectional()==1);
		t.setSaleNy(coupon.getIsGroupPurchase() == 1);
		// TODO 待转换
		t.setStoreAll(coupon.getShopType()+"");
		t.setMinOrderAmt(coupon.getAmount());
		t.setAmt(coupon.getCouponValue());
		return t;
	}
	
	public String getCouponId() {
		return couponId;
	}
	public void setCouponId(String couponId) {
		this.couponId = couponId;
	}
	public String getMemberId() {
		return memberId;
	}
	public void setMemberId(String memberId) {
		this.memberId = memberId;
	}
	public String getCpnTptId() {
		return cpnTptId;
	}
	public void setCpnTptId(String cpnTptId) {
		this.cpnTptId = cpnTptId;
	}
	public String getPreCouponId() {
		return preCouponId;
	}
	public void setPreCouponId(String preCouponId) {
		this.preCouponId = preCouponId;
	}
	public Boolean getShareNy() {
		return shareNy;
	}
	public void setShareNy(Boolean shareNy) {
		this.shareNy = shareNy;
	}
	public Boolean getSaleNy() {
		return saleNy;
	}
	public void setSaleNy(Boolean saleNy) {
		this.saleNy = saleNy;
	}
	public BigDecimal getMinOrderAmt() {
		return minOrderAmt;
	}
	public void setMinOrderAmt(BigDecimal minOrderAmt) {
		this.minOrderAmt = minOrderAmt;
	}
	public String getCpnLevel() {
		return cpnLevel;
	}
	public void setCpnLevel(String cpnLevel) {
		this.cpnLevel = cpnLevel;
	}
	public String getLimitFlag() {
		return limitFlag;
	}
	public void setLimitFlag(String limitFlag) {
		this.limitFlag = limitFlag;
	}
	public String getStoreAll() {
		return storeAll;
	}
	public void setStoreAll(String storeAll) {
		this.storeAll = storeAll;
	}
	public String getProduceAll() {
		return produceAll;
	}
	public void setProduceAll(String produceAll) {
		this.produceAll = produceAll;
	}
	public BigDecimal getAmt() {
		return amt;
	}
	public void setAmt(BigDecimal amt) {
		this.amt = amt;
	}
	public BigDecimal getSaleAmt() {
		return saleAmt;
	}
	public void setSaleAmt(BigDecimal saleAmt) {
		this.saleAmt = saleAmt;
	}
	public BigDecimal getDiscount() {
		return discount;
	}
	public void setDiscount(BigDecimal discount) {
		this.discount = discount;
	}
	public Date getValidDate() {
		return validDate;
	}
	public void setValidDate(Date validDate) {
		this.validDate = validDate;
	}
	public Date getInvalidDate() {
		return invalidDate;
	}
	public void setInvalidDate(Date invalidDate) {
		this.invalidDate = invalidDate;
	}
	public String getPmtOrderId() {
		return pmtOrderId;
	}
	public void setPmtOrderId(String pmtOrderId) {
		this.pmtOrderId = pmtOrderId;
	}
	public String getLineId() {
		return lineId;
	}
	public void setLineId(String lineId) {
		this.lineId = lineId;
	}
	public String getUsedOrderId() {
		return usedOrderId;
	}
	public void setUsedOrderId(String usedOrderId) {
		this.usedOrderId = usedOrderId;
	}
	public String getWerks() {
		return werks;
	}
	public void setWerks(String werks) {
		this.werks = werks;
	}
	public Date getUsedTime() {
		return usedTime;
	}
	public void setUsedTime(Date usedTime) {
		this.usedTime = usedTime;
	}
	public String getPaymentCode() {
		return paymentCode;
	}
	public void setPaymentCode(String paymentCode) {
		this.paymentCode = paymentCode;
	}
	public String getValidFlag() {
		return validFlag;
	}
	public void setValidFlag(String validFlag) {
		this.validFlag = validFlag;
	}
	public String getMark() {
		return mark;
	}
	public void setMark(String mark) {
		this.mark = mark;
	}
	public Integer getExportDataTimes() {
		return exportDataTimes;
	}
	public void setExportDataTimes(Integer exportDataTimes) {
		this.exportDataTimes = exportDataTimes;
	}
	
}
