/*
 * *
 *  * @(#)DepositInfoReqDto.java 2.0.0 7/10/19 7:18 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

import static com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.ExtAttributeConstants.SALES_PROMOTION_RECHARGE_ACCOUNT_FLOW_ID;
import static com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.ExtAttributeConstants.SALES_PROMOTION_RECHARGE_AMOUNT;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel
public class DepositInfoReqDto extends BasePromotionDto {

    private static final long serialVersionUID = -2358069966788956822L;

    @ApiModelProperty(name = "money", value = "充值金额")
    private BigDecimal money;
    @ApiModelProperty(name = "channel", value = "渠道名称")
    private String channel;

    /**
     * 储值流水id
     */
    @ApiModelProperty(name = "channel", value = "渠道名称")
    private Long accountFlowId;

    @ApiModelProperty(name = "channel", value = "渠道名称")
    private Long activityTemplateId;

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Long getAccountFlowId() {
        return accountFlowId;
    }

    public void setAccountFlowId(Long accountFlowId) {
        this.accountFlowId = accountFlowId;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    /**
     * 转换为引擎执行需要的参数
     *
     * @return
     */
    public EngineParams toParams() {
        EngineParams params = new EngineParams();
        params.addExtAttribute(SALES_PROMOTION_RECHARGE_AMOUNT, this.getMoney());
        params.addExtAttribute(SALES_PROMOTION_RECHARGE_ACCOUNT_FLOW_ID, this.getAccountFlowId());
        params.setShopId(this.getShopCode());
        params.setUserId(this.getMemberId());
        params.setProgramSrc(this.getChannel());
        params.setSerialNumber(this.getShopCode());
        params.setShopId(this.getShopCode());
        params.setOrderCode(getTradeCode());
        return params;
    }


    @Override
    public String toString() {
        return "DepositInfoReqDto{" +
                "memberId=" + getMemberId() +
                ", shopCode=" + getShopCode() +
                ", money=" + money +
                ", channel='" + channel + '\'' +
                ", tradeCode='" + getTradeCode() + '\'' +
                '}';
    }
}
