package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 分期请求，目前有积分和储值
 *
 * @author chen.fangliang
 * @date 2019/7/12 15:28
 */
public class InstallmentReqDto extends BaseVo {

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "businessNo", value = "业务单号")
    private String businessNo;

    @ApiModelProperty(name = "num", value = "数量")
    private BigDecimal totalNum;

    @ApiModelProperty(name = "validityDay", value = "有效期(天)")
    private Integer validityDay;


    @ApiModelProperty(name = "monthlyInstallment", value = "按月分期（月），分几个月赠送")
    private Integer monthlyInstallment;

    /**
     * 每月到账金额为储值金额/按月分期值。首期到账参考赠送到账延期时间，后续发放日统一为1号
     */
    @ApiModelProperty(name = "postpone", value = "首次延期到账天数")
    private Integer postpone;

    /**
     * 目前存优惠券模板id
     */
    @ApiModelProperty(name = "objId", value = "目前存优惠券模板id")
    private Long objId;

    private Map<String, Object> extension = Maps.newHashMap();

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getValidityDay() {
        return validityDay;
    }

    public void setValidityDay(Integer validityDay) {
        this.validityDay = validityDay;
    }

    public Integer getMonthlyInstallment() {
        return monthlyInstallment;
    }

    public void setMonthlyInstallment(Integer monthlyInstallment) {
        this.monthlyInstallment = monthlyInstallment;
    }

    public Integer getPostpone() {
        return postpone;
    }

    public void setPostpone(Integer postpone) {
        this.postpone = postpone;
    }

    public String getBusinessNo() {
        return businessNo;
    }

    public void setBusinessNo(String businessNo) {
        this.businessNo = businessNo;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getObjId() {
        return objId;
    }

    public void setObjId(Long objId) {
        this.objId = objId;
    }

    public Map<String, Object> getExtension() {
        return extension;
    }

    public Object putExtension(String key, Object obj) {
        return extension.put(key, obj);
    }

    public void setExtension(Map<String, Object> extension) {
        this.extension = extension;
    }
}
