package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PresentReferEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PresentTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author chen.fangliang
 * @date 2019/7/9 13:37
 */
@ApiModel(value = "PresentReqDto", description = "赠品Dto")
public class PresentReqDto extends RequestDto {

    @ApiModelProperty(name = "groupName", value = "赠品组名称")
    @NotNull
    private String groupName;

    @ApiModelProperty(name = "presentType", value = "促销大类")
    @NotNull
    private PresentTypeEnum presentType;

    @ApiModelProperty(name = "reference", value = "0未被引用，1被引用")
    private PresentReferEnum reference;

    @ApiModelProperty(name = "presentList", value = "赠品明细")
    private List<PresentInfoDto> presentList;

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public PresentTypeEnum getPresentType() {
        return presentType;
    }

    public void setPresentType(PresentTypeEnum presentType) {
        this.presentType = presentType;
    }

    public List<PresentInfoDto> getPresentList() {
        return presentList;
    }

    public void setPresentList(List<PresentInfoDto> presentList) {
        this.presentList = presentList;
    }

    public PresentReferEnum getReference() {
        return reference;
    }

    public void setReference(PresentReferEnum reference) {
        this.reference = reference;
    }
}
