/*
 * *
 *  * @(#)ProductGroup.java 2.0.0 7/17/19 7:03 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/**
 * Project Name:lppz-promotion-soa
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 套装商品
 *
 * @author Alex
 */
public class ProductGroup implements Serializable {

    private static final long serialVersionUID = 4163965838713549260L;
    private String sku;
    private String promId;
    private String prodGrp;
    private Integer minQuan;
    private Integer maxQuan;
    private BigDecimal amount;

    @Override
    public int hashCode() {
        return (sku + promId).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProductGroup) {
            ProductGroup prodGrp = (ProductGroup) obj;
            return prodGrp.getSku().equals(sku) && prodGrp.getPromId().equals(promId);
        }
        return super.equals(obj);
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getPromId() {
        return promId;
    }

    public void setPromId(String promId) {
        this.promId = promId;
    }

    public String getProdGrp() {
        return prodGrp;
    }

    public void setProdGrp(String prodGrp) {
        this.prodGrp = prodGrp;
    }

    public Integer getMinQuan() {
        return minQuan;
    }

    public void setMinQuan(Integer minQuan) {
        this.minQuan = minQuan;
    }

    public Integer getMaxQuan() {
        return maxQuan;
    }

    public void setMaxQuan(Integer maxQuan) {
        this.maxQuan = maxQuan;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
}