/**
 * *
 * * @(#)promotion.java 2.0.0 7/17/19 7:03 PM
 * * author: luo.lei
 * * Copyright (c)  2018, YUNXI. All rights reserved.
 * * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/***
 * 促销
 *
 * @author Alex
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Promotion implements Serializable {

    private static final long serialVersionUID = 3536993535267962279L;

    private String promId = "";
    private String promCode = "";
    @JsonFormat(pattern = "yyyyMMddHHmmss")
    @JSONField(format = "yyyyMMddHHmmss")
    private Date createdate;
    @JsonFormat(pattern = "yyyyMMddHHmmss")
    @JSONField(format = "yyyyMMddHHmmss")
    private Date modifydate;
    private String promTitle = "";
    private String promName = "";
    private String promDesc = "";
    /***
     * 促销类型 A 满折 B 满减 C 满返 D 满赠 E 加价购 F 组合促销
     */
    private String promType = "";
    /***
     * 阶梯id
     */
    private String laddeId = "";
    @JsonFormat(pattern = "yyyyMMddHHmmss")
    @JSONField(format = "yyyyMMddHHmmss")
    private Date startdate;
    @JsonFormat(pattern = "yyyyMMddHHmmss")
    @JSONField(format = "yyyyMMddHHmmss")
    private Date enddate;
    private BigDecimal maxPrice = new BigDecimal("999999");
    private int maxQuan = 999999;
    private BigDecimal minPrice = new BigDecimal("999999");
    private int minQuan = 0;

    //o2oChannel.用这个字段判断APP 3倍积分
    @JsonProperty(value = "O2O_CHANNEL")
    @JSONField(name = "o2o_channel")
    private String o2oChannel;

    /**
     * 促销积分表达式
     */
    private String pointExpr = "";
    /**
     * 促销价格表达式
     */
    private String priceExpr = "";
    /**
     * 返还积分表达式
     */
    private String rtnPointExpr = "";
    /**
     * CRM促销大类，1、整单，2、单品，3、品类
     */
    private String pmtMtype = "";
    @JsonProperty(value = "isCouponAllowed")

    private boolean isCouponAllowed;
    @JsonProperty(value = "isFreepost")

    private boolean isFreepost;
    @JsonProperty(value = "isForOrder")

    private boolean isForOrder;
    @JsonProperty(value = "isUniPrice")

    private boolean isUniPrice;//是否统一价
    @JsonProperty(value = "isMarkup")

    private boolean isMarkup;//是否加价购
    @JsonProperty(value = "isGrp")

    private boolean isGrp;//是否组合商品
    @JsonProperty(value = "isForAll")

    private boolean isForAll;//是否全场促销
    @JsonProperty(value = "isEachFull")

    private boolean isEachFull;//是否每满
    @JsonProperty(value = "isLadde")

    private boolean isLadde;//是否阶梯
    @JsonProperty(value = "isEnabled")

    private boolean isEnabled;


    private BigDecimal promAmt;//优惠价格
    private String sku = "";//促销商品sku
    private int rtnPoint;//返还积分

    /**
     * 10 全部； 20 水果； 30 零食
     */
    @JsonProperty("mg_id")
    @JSONField(name = "mg_id")
    private String mGid = "10";


    /**
     * 促销商品
     */
    private Set<Product> products = new HashSet<>(1);
    /**
     * 赠品
     */
    private Set<Gift> gifts = new HashSet<>(1);
    /**
     * 随机赠品
     */
    private Set<GiftRdm> giftRdms = new HashSet<>(1);
    /**
     * 互斥组
     */
    private Set<Mutex> mutexes = new HashSet<>(1);
    /**
     * 加价购商品
     */
    private Set<ProductMarkup> prodMarkups = new HashSet<>(1);
    /**
     * 组合促销商品
     */
    private Set<ProductGroup> prodGrps = new HashSet<>(1);
    /**
     * 统一价商品
     */
    private Set<Product> prodUniPrcs = new HashSet<>(1);
    /**
     * 返还优惠券
     */
    private List<Coupon> rtnCoupons = Lists.newLinkedList();

    /*** 品牌Id */
    private Set<String> brandIds = new HashSet<>(1);
    /**
     * 渠道Id
     */
    private Set<String> chnlIds = new HashSet<>(1);


    /**
     * 店铺类型 内部处理字段 0所有店铺，1线上店铺，2线下店铺
     */
    @JsonIgnore
    @Transient
    private Integer channelType;


    /**
     * 会员Id
     */
    private Set<String> uids = new HashSet<>(1);
    /**
     * 会员级别
     */
    private Set<String> memLvls = new HashSet<>(1);
    /**
     * 营销对象
     */
    @JsonProperty("makObj")
    @JSONField(name = "makObj")
    private Set<String> makObjs = new HashSet<>(1);
    /**
     * 商品类别Id
     */
    private Set<String> prodCateIds = new HashSet<>(1);
    /**
     * 商品skus
     */
    private Set<String> skus = new HashSet<>(1);
    /**
     * 排除商品skus
     */
    private Set<String> skuExcls = new HashSet<>(1);
    /**
     * 统一价商品skus
     */
    private Set<String> skuUniPrcs = new HashSet<>(1);

    // @Transient
    private List<Promotion> subPromotions = new LinkedList<>();


    @Override
    public int hashCode() {
        String pmtId = promId;
        return pmtId.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Promotion) {
            Promotion promotion = (Promotion) obj;
            if (!StringUtils.isEmpty(promId)) {
                return (promotion.getPromId().equals(promId));
            }
        }
        return super.equals(obj);
    }

    public void setDiscount(int type, BigDecimal value) {
        if (1 == type) {
            this.setMinPrice(value);
            this.setMinQuan(0);
        } else {
            this.setMinQuan(value.intValue());
            this.setMinPrice(BigDecimal.ZERO);
        }
    }


    public void setCondition(int condition, String promId) {
        if (2 == condition) {
            this.setEachFull(true);
        } else if (3 == condition) {
            this.setLadde(true);
            this.setLaddeId(promId);
        }
    }

    public String getO2oChannel() {
        return o2oChannel;
    }

    public void setO2oChannel(String o2oChannel) {
        this.o2oChannel = o2oChannel;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public String getPromId() {
        return promId;
    }

    public void setPromId(String promId) {
        this.promId = promId;
    }

    public String getPromCode() {
        return promCode;
    }

    public void setPromCode(String promCode) {
        this.promCode = promCode;
    }

    public Date getCreatedate() {
        return createdate;
    }

    public void setCreatedate(Date createdate) {
        this.createdate = createdate;
    }

    public Date getModifydate() {
        return modifydate;
    }

    public void setModifydate(Date modifydate) {
        this.modifydate = modifydate;
    }

    public String getPromTitle() {
        return promTitle;
    }

    public void setPromTitle(String promTitle) {
        this.promTitle = promTitle;
    }

    public String getPromName() {
        return promName;
    }

    public void setPromName(String promName) {
        this.promName = promName;
    }

    public String getPromDesc() {
        return promDesc;
    }

    public void setPromDesc(String promDesc) {
        this.promDesc = promDesc;
    }

    public String getPromType() {
        return promType;
    }

    public void setPromType(String promType) {
        this.promType = promType;
    }

    public String getLaddeId() {
        return laddeId;
    }

    public void setLaddeId(String laddeId) {
        this.laddeId = laddeId;
    }

    public Date getStartdate() {
        return startdate;
    }

    public void setStartdate(Date startdate) {
        this.startdate = startdate;
    }

    public Date getEnddate() {
        return enddate;
    }

    public void setEnddate(Date enddate) {
        this.enddate = enddate;
    }


    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public Integer getMinQuan() {
        return minQuan;
    }

    public void setMinQuan(Integer minQuan) {
        this.minQuan = minQuan;
    }

    public String getPointExpr() {
        return pointExpr;
    }

    public void setPointExpr(String pointExpr) {
        this.pointExpr = pointExpr;
    }

    public String getPriceExpr() {
        return priceExpr;
    }

    public void setPriceExpr(String priceExpr) {
        this.priceExpr = priceExpr;
    }

    public String getRtnPointExpr() {
        return rtnPointExpr;
    }

    public void setRtnPointExpr(String rtnPointExpr) {
        this.rtnPointExpr = rtnPointExpr;
    }

    @JSONField(name = "isCouponAllowed")
    public boolean getCouponAllowed() {
        return isCouponAllowed;
    }

    public void setCouponAllowed(boolean couponAllowed) {
        isCouponAllowed = couponAllowed;
    }

    @JSONField(name = "isFreepost")
    public boolean getFreepost() {
        return isFreepost;
    }

    public void setFreepost(boolean freepost) {
        isFreepost = freepost;
    }

    @JSONField(name = "isForOrder")
    public boolean getForOrder() {
        return "1".equals(this.pmtMtype);
    }

    public void setForOrder(boolean forOrder) {
        isForOrder = forOrder;
    }

    @JSONField(name = "isUniPrice")
    public boolean getUniPrice() {
        return isUniPrice;
    }

    public void setUniPrice(boolean uniPrice) {
        isUniPrice = uniPrice;
    }

    @JSONField(name = "isMarkup")
    public boolean getMarkup() {
        return isMarkup;
    }

    public void setMarkup(boolean markup) {
        isMarkup = markup;
    }

    @JSONField(name = "isGrp")
    public boolean getGrp() {
        return isGrp;
    }

    public void setGrp(boolean grp) {
        isGrp = grp;
    }

    @JSONField(name = "isForAll")
    public boolean getForAll() {
        return isForAll;
    }

    public void setForAll(boolean forAll) {
        isForAll = forAll;
    }

    @JSONField(name = "isEachFull")
    public boolean getEachFull() {
        return isEachFull;
    }

    public void setEachFull(boolean eachFull) {
        isEachFull = eachFull;
    }

    @JSONField(name = "isLadde")
    public boolean getLadde() {
        return isLadde;
    }

    public void setLadde(boolean ladde) {
        isLadde = ladde;
    }

    @JSONField(name = "isEnabled")
    public boolean getEnabled() {
        return isEnabled;
    }

    public void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }

    public BigDecimal getPromAmt() {
        return promAmt;
    }

    public void setPromAmt(BigDecimal promAmt) {
        this.promAmt = promAmt;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Integer getRtnPoint() {
        return rtnPoint;
    }

    public void setRtnPoint(Integer rtnPoint) {
        this.rtnPoint = rtnPoint;
    }

    public Set<Product> getProducts() {
        return products;
    }

    public void setProducts(Set<Product> products) {
        this.products = products;
    }

    public Set<Gift> getGifts() {
        return gifts;
    }

    public void setGifts(Set<Gift> gifts) {
        this.gifts = gifts;
    }

    public Set<GiftRdm> getGiftRdms() {
        return giftRdms;
    }

    public void setGiftRdms(Set<GiftRdm> giftRdms) {
        this.giftRdms = giftRdms;
    }

    public Set<Mutex> getMutexes() {
        return mutexes;
    }

    public void setMutexes(Set<Mutex> mutexes) {
        this.mutexes = mutexes;
    }

    public Set<ProductMarkup> getProdMarkups() {
        return prodMarkups;
    }

    public void setProdMarkups(Set<ProductMarkup> prodMarkups) {
        this.prodMarkups = prodMarkups;
    }

    public Set<ProductGroup> getProdGrps() {
        return prodGrps;
    }

    public void setProdGrps(Set<ProductGroup> prodGrps) {
        this.prodGrps = prodGrps;
    }

    public Set<Product> getProdUniPrcs() {
        return prodUniPrcs;
    }

    public void setProdUniPrcs(Set<Product> prodUniPrcs) {
        this.prodUniPrcs = prodUniPrcs;
    }

    public List<Coupon> getRtnCoupons() {
        return rtnCoupons;
    }

    public void setRtnCoupons(List<Coupon> rtnCoupons) {
        this.rtnCoupons = rtnCoupons;
    }

    public Set<String> getBrandIds() {
        return brandIds;
    }

    public void setBrandIds(Set<String> brandIds) {
        this.brandIds = brandIds;
    }

    public Set<String> getChnlIds() {
        return chnlIds;
    }

    public void setChnlIds(Set<String> chnlIds) {
        this.chnlIds = chnlIds;
    }

    public Set<String> getUids() {
        return uids;
    }

    public void setUids(Set<String> uids) {
        this.uids = uids;
    }

    public Set<String> getMemLvls() {
        return memLvls;
    }

    public void setMemLvls(Set<String> memLvls) {
        this.memLvls = memLvls;
    }

    public Set<String> getProdCateIds() {
        return prodCateIds;
    }

    public void setProdCateIds(Set<String> prodCateIds) {
        this.prodCateIds = prodCateIds;
    }

    public Set<String> getSkus() {
        return skus;
    }

    public void setSkus(Set<String> skus) {
        this.skus = skus;
    }

    public Set<String> getSkuExcls() {
        return skuExcls;
    }

    public void setSkuExcls(Set<String> skuExcls) {
        this.skuExcls = skuExcls;
    }

    public Set<String> getSkuUniPrcs() {
        return skuUniPrcs;
    }

    public void setSkuUniPrcs(Set<String> skuUniPrcs) {
        this.skuUniPrcs = skuUniPrcs;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Integer getMaxQuan() {
        return maxQuan;
    }

    public void setMaxQuan(Integer maxQuan) {
        this.maxQuan = maxQuan;
    }

    public String getPmtMtype() {
        return pmtMtype;
    }

    public void setPmtMtype(String pmtMtype) {
        this.pmtMtype = pmtMtype;
    }

    public String getmGid() {
        return mGid;
    }

    public void setmGid(String mGid) {
        this.mGid = mGid;
    }

    public Set<String> getMakObjs() {
        return makObjs;
    }

    public void setMakObjs(Set<String> makObjs) {
        this.makObjs = makObjs;
    }

    public void addSubPromotions(Promotion promotion) {
        if (!CollectionUtils.isEmpty(this.getSubPromotions())) {
            //            if (isLadde) {
//                master.setPromId(master.laddeId + "1");
//            }
//            promotion.setLadde(true);
            promotion.setPromId(promotion.laddeId + (this.getSubPromotions().size() + 1));
//            promotion.setLaddeId(master.getPromId());
            BigDecimal lastPrice = this.getSubPromotions().get(this.getSubPromotions().size() - 1).getMinPrice();
            if (!lastPrice.equals(BigDecimal.ZERO)) {
                promotion.setMaxPrice(lastPrice);
            }
            int lastPiece = this.getSubPromotions().get(this.getSubPromotions().size() - 1).getMinQuan();
            if (0 != lastPiece) {
                promotion.setMaxQuan(lastPiece);
            }
        }
        promotion.setForAll(this.getForAll());
        this.getSubPromotions().add(promotion);
    }

    public List<Promotion> getSubPromotions() {
        return subPromotions;
    }

    public void addProdMarkups(ProductMarkup up) {
        up.setPromId(this.getPromId());
        this.prodMarkups.add(up);
    }


    @Override
    public Promotion clone() {
        Promotion promotion = new Promotion();
        promotion.setPromId(this.promId);
        promotion.setPromCode(this.promCode);
        promotion.setCreatedate(this.createdate);
        promotion.setModifydate(this.modifydate);
        promotion.setStartdate(this.startdate);
        promotion.setEnddate(this.enddate);
        promotion.setPromTitle(this.promTitle);
        promotion.setPromName(this.promName);
        promotion.setPromDesc(this.promDesc);
        promotion.setPmtMtype(this.pmtMtype);
        promotion.setEnabled(this.isEnabled);
        promotion.setPromType(this.promType);
        promotion.setMarkup(this.isMarkup);
        promotion.setLadde(this.isLadde);
        promotion.setMemLvls(this.memLvls);
        promotion.setSkus(this.getSkus());
        promotion.setChnlIds(this.chnlIds);
        promotion.setmGid(this.mGid);
        promotion.setO2oChannel(this.o2oChannel);
        return promotion;
    }

}