/*
 * *
 *  * @(#)PromotionBaseConditionDto.java 2.0.0 7/9/19 2:05 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author luo.lei
 * @since 2.0.0
 */
public class PromotionBaseConditionDto {

    /**
     * 人群类型 0：所有会员，1，指定人群，2指定等级
     */
    @ApiModelProperty(value = "人群类型 0：所有会员，1，指定人群，2指定等级")
    private int memberType;

    /**
     * 目标人群id集合
     */
    @ApiModelProperty(value = "人群或等级集合")
    private List<Long> memberIds;

    /**
     * 0所有店铺，1线上店铺，2线下店铺 3 部分店铺 4 排除部分店铺
     */
    @ApiModelProperty(value = "0所有店铺，1线上店铺，2线下店铺 3 部分店铺 4 排除部分店铺")
    private int shopType;

    @ApiModelProperty(value = "店铺集")
    private List<String> shopCodes;

    @ApiModelProperty(value = "商品类型 0全部,1水果,2零食")
    private int itemType;

    @ApiModelProperty(value = "商品集")
    private List<String> itemCodes;

    public int getMemberType() {
        return memberType;
    }

    public void setMemberType(int memberType) {
        this.memberType = memberType;
    }

    public List<Long> getMemberIds() {
        return memberIds;
    }

    public void setMemberIds(List<Long> memberIds) {
        this.memberIds = memberIds;
    }

    public int getShopType() {
        return shopType;
    }

    public void setShopType(int shopType) {
        this.shopType = shopType;
    }


    public List<String> getShopCodes() {
        return shopCodes;
    }

    public void setShopCodes(List<String> shopCodes) {
        this.shopCodes = shopCodes;
    }

    public int getItemType() {
        return itemType;
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    public List<String> getItemCodes() {
        return itemCodes;
    }

    public void setItemCodes(List<String> itemCodes) {
        this.itemCodes = itemCodes;
    }
}
