/*
 * *
 *  * @(#)PromotionBaseInfoDto.java 2.0.0 7/4/19 2:13 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.*;
import java.util.Date;

/**
 * 活动基本信息
 *
 * @author luo.lei
 * @since 2.0.0
 */
public class PromotionBaseInfoDto extends CommonVo {


    public static final String PROMOTION_TYPE_ENUM_ALL = "ALL";
    public static final String PROMOTION_TYPE_ENUM_COLLECTION = "COLLECTION";
    public static final String PROMOTION_TYPE_ENUM_ITEM = "ITEM";


    /**
     * 活动名称
     */
    @ApiModelProperty("活动名称")
    @NotEmpty(message = "活动名称不能为空")
    private String activityName;

    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    private String desc;

    /**
     * 活动模版
     */
    @NotNull(message = "活动模版不能为空")
    @ApiModelProperty("活动类型")
    private ActivityType activityType;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @NotNull(message = "活动开始时间不能为空")
    private Date beginTime;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @Future(message = "活动结束时间不能小于当前时间")
    private Date endTime;

    /**
     * 活动预热开始时间
     */
    @ApiModelProperty(name = "preheatStartTime", value = "活动预热开始时间")
    private Date preheatStartTime;

    /**
     * 活动预热结束时间
     */
    @ApiModelProperty(name = "preheatEndTime", value = "活动预热结束时间")
    private Date preheatEndTime;

    /**
     * 活动范围：1-平台， 2-商家
     */
    @ApiModelProperty(name = "activityRange", value = "活动范围：1-平台， 2-商家")
    private Integer activityRange;

    /**
     * 促销大类 ALL 整单、COLLECTION 集合、ITEM 单品
     */
    @ApiModelProperty("促销大类 ALL 整单、COLLECTION 集合、ITEM 单品")
    @Pattern(regexp = "ALL|COLLECTION|ITEM", message = "请输入合法的值")
    private String promotionType;
    /**
     * 互斥量
     */
    @ApiModelProperty("互斥量:0-不互斥，1-与优惠券互斥")
    @Min(value = 0, message = "互斥权重不能小于0")
    private int mutex;
    /**
     * 营销计划
     */
    @ApiModelProperty("营销计划ID，没有填0")
    private Long promotionPlainId;

    @ApiModelProperty("活动编号，新增活动时不需要传")
    private String activityCode;

    @ApiModelProperty("o2o渠道")
    private String o2oChannel;

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public ActivityType getActivityType() {
        return activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getPromotionType() {
        return promotionType;
    }

    public void setPromotionType(String promotionType) {
        this.promotionType = promotionType;
    }

    public int getMutex() {
        return mutex;
    }

    public void setMutex(int mutex) {
        this.mutex = mutex;
    }

    public Long getPromotionPlainId() {
        return promotionPlainId;
    }

    public void setPromotionPlainId(Long promotionPlainId) {
        this.promotionPlainId = promotionPlainId;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getO2oChannel() {
        return o2oChannel;
    }

    public void setO2oChannel(String o2oChannel) {
        this.o2oChannel = o2oChannel;
    }

    public Date getPreheatStartTime() {
        return preheatStartTime;
    }

    public void setPreheatStartTime(Date preheatStartTime) {
        this.preheatStartTime = preheatStartTime;
    }

    public Date getPreheatEndTime() {
        return preheatEndTime;
    }

    public void setPreheatEndTime(Date preheatEndTime) {
        this.preheatEndTime = preheatEndTime;
    }

    public Integer getActivityRange() {
        return activityRange;
    }

    public void setActivityRange(Integer activityRange) {
        this.activityRange = activityRange;
    }
}
