/*
 * *
 *  * @(#)PromotionDepositInfoDto.java 2.0.0 7/4/19 3:43 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ReturnType;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 储值赠礼规则
 *
 * @author luo.lei
 * @since 2.0.0
 */
public class PromotionDepositInfoDto extends PromotionDto {


    /**
     * 过期时长
     */
    @ApiModelProperty("过期时长")
    @Min(value = 0, message = "过期时长必须大于0")
    private int overdue;

    /**
     * 上限
     */
    @ApiModelProperty("上限")
    private Integer upperLimit;

    /**
     * 分期
     */
    @ApiModelProperty("分期")
    @Min(value = 0, message = "分期必须大于0")
    private int instalment;

    /**
     * 延时发放
     */
    @Min(value = 0, message = "延时发放时间要大于0")
    @ApiModelProperty("首期延时发放时间")
    private int delayed;

    @ApiModelProperty("赠礼类型，目前只有POINT、COUPON、DEPOSIT")
    private ReturnType returnType;

    @NotEmpty(message = "促销规则不能为空")
    private List<PromotionRulesDto> rulesDtos;


    public int getOverdue() {
        return overdue;
    }

    public void setOverdue(int overdue) {
        this.overdue = overdue;
    }

    public Integer getUpperLimit() {
        return upperLimit;
    }

    public void setUpperLimit(Integer upperLimit) {
        this.upperLimit = upperLimit;
    }

    public int getInstalment() {
        return instalment;
    }

    public void setInstalment(int instalment) {
        this.instalment = instalment;
    }

    public int getDelayed() {
        return delayed;
    }

    public void setDelayed(int delayed) {
        this.delayed = delayed;
    }

    public List<PromotionRulesDto> getRulesDtos() {
        return rulesDtos;
    }

    public void setRulesDtos(List<PromotionRulesDto> rulesDtos) {
        this.rulesDtos = rulesDtos;
    }

    public ReturnType getReturnType() {
        return returnType;
    }

    public void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }
}
